/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Header;
import option.io.pdfcommon.document.PdfDocumentInfo;
import option.io.pdfcommon.document.Trailer;
import option.io.pdfcommon.document.XrefReference;
import option.io.pdfcommon.document.XrefTable;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfDocument {
    private Body body;
    private Header header;
    private XrefTable xref;
    private Trailer trailer;
    private PdfDocumentInfo info = new PdfDocumentInfo(this);
    private PdfOutFile outFile;

    public PdfDocument() {
        this.body = new Body(this);
        this.outFile = new PdfOutFile();
    }

    public Body getBody() {
        return this.body;
    }

    public XrefTable getXref() {
        return this.xref;
    }

    protected void setOutput() {
        this.header = new Header();
        this.xref = new XrefTable();
        this.trailer = new Trailer();
        this.body.add(this.info);
        this.xref.addElement(new XrefReference(0, 65535, false));
        this.header.write(this.outFile);
        this.body.write(this.outFile);
        this.trailer.setLocationOfXref(this.outFile.size());
        this.trailer.setSize(this.xref.size());
        this.trailer.setRoot(this.body.getCatalog());
        this.trailer.setInfo(this.info);
        this.xref.write(this.outFile);
        this.trailer.write(this.outFile);
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.outFile.getByteStream();
    }

    public byte[] getData() {
        return this.outFile.getData();
    }

    public void setData(byte[] b) {
        this.outFile.setData(b);
    }

    public void flush() {
        this.body.flush();
        this.outFile.flush();
    }

    public void close() {
        this.body.clear();
        this.outFile.close();
    }

    public boolean writeToFile() {
        this.setOutput();
        try {
            this.outFile.writeToFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void writeToStream(OutputStream out) {
        this.setOutput();
        this.outFile.writeToStream(out);
    }

    public void writeToFile(String fileName) {
        this.setOutput();
        this.outFile.writeToFile(fileName);
    }

    public PdfOutFile getOutputFile() {
        return this.outFile;
    }

    public void setOutputFile(PdfOutFile file) {
        this.outFile = file;
    }

    public PdfDocumentInfo getInfo() {
        return this.info;
    }

    public void setInfo(PdfDocumentInfo info) {
        info.setDocument(this);
        this.info = info;
    }
}

