/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Color;
import java.util.StringTokenizer;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathArc;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathLine;
import option.io.pdfcommon.path.PathLink;
import option.io.pdfcommon.path.PathMulti;
import option.io.pdfcommon.path.PathMultiElementBezier;
import option.io.pdfcommon.path.PathMultiElementClose;
import option.io.pdfcommon.path.PathMultiElementLine;
import option.io.pdfcommon.path.PathMultiElementMove;
import option.io.pdfcommon.path.PathPolygon;
import option.io.pdfcommon.path.PathPolyline;
import option.io.pdfcommon.path.PathRectangle;
import option.io.pdfcommon.path.PathText;

public class PdfDrawCommandParser
implements PdfDataConst {
    protected String mBase;

    public PdfDrawCommandParser(String base) {
        this.mBase = base;
    }

    public Path parseDrawCommand(String command) {
        Path path = null;
        StringTokenizer st = new StringTokenizer(command, ", ");
        if (!st.hasMoreTokens()) {
            return path;
        }
        String cmd = st.nextToken().trim();
        if (cmd.equals("line")) {
            path = this.createLine(command);
        } else if (cmd.equals("text")) {
            path = this.createText(command);
        } else if (cmd.equals("rect")) {
            path = this.createRect(command);
        } else if (cmd.equals("arc")) {
            path = this.createArc(command);
        } else if (cmd.equals("polygon")) {
            path = this.createPolygon(command);
        } else if (cmd.equals("polyline")) {
            path = this.createPolyline(command);
        } else if (cmd.equals("image")) {
            path = this.createImage(command);
        } else if (cmd.equals("jpeg")) {
            path = this.createJpegImage(command);
        } else if (cmd.equals("link")) {
            path = this.createLink(command);
        } else if (cmd.equals("3d")) {
            path = this.create3D(command);
        }
        return path;
    }

    protected Path createArc(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count >= 14) {
            st.nextToken();
            float x = Float.parseFloat(st.nextToken());
            float y = Float.parseFloat(st.nextToken());
            float width = Float.parseFloat(st.nextToken());
            float height = Float.parseFloat(st.nextToken());
            float startAngle = Float.parseFloat(st.nextToken());
            float angle = Float.parseFloat(st.nextToken()) - startAngle;
            Color color = this.parseColor(st);
            boolean fill = this.parseFill(st);
            float lineWidth = Float.parseFloat(st.nextToken());
            return new PathArc(x, y, width, height, startAngle, angle, new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st))), color, fill);
        }
        return null;
    }

    protected PathImage createImage(String s) {
        return null;
    }

    protected Path createJpegImage(String s) {
        return null;
    }

    protected Path createLine(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count >= 11) {
            st.nextToken();
            float x1 = Float.parseFloat(st.nextToken());
            float y1 = Float.parseFloat(st.nextToken());
            float x2 = Float.parseFloat(st.nextToken());
            float y2 = Float.parseFloat(st.nextToken());
            Color color = this.parseColor(st);
            float lineWidth = Float.parseFloat(st.nextToken());
            try {
                return new PathLine(x1, y1, x2, y2, new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st))), color);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Path createLink(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count != 7) {
            return null;
        }
        st.nextToken();
        String url = st.nextToken();
        float lux = Float.parseFloat(st.nextToken());
        float luy = Float.parseFloat(st.nextToken());
        float rdx = Float.parseFloat(st.nextToken());
        float rdy = Float.parseFloat(st.nextToken());
        float borderWidth = Float.parseFloat(st.nextToken());
        return new PathLink(url, lux, luy, rdx, rdy, borderWidth);
    }

    protected Path createMultiPath(String s) {
        String commandLine;
        StringTokenizer st2;
        String command;
        PathMulti pm = new PathMulti();
        StringTokenizer st = new StringTokenizer(s, "\r\n");
        while (st.hasMoreElements() && (command = (st2 = new StringTokenizer(commandLine = st.nextToken(), ", ")).nextToken()) != null) {
            if (command.equalsIgnoreCase("moveto")) {
                float x = Float.parseFloat(st2.nextToken());
                float y = Float.parseFloat(st2.nextToken());
                pm.addPath(new PathMultiElementMove(x, y));
                continue;
            }
            if (command.equalsIgnoreCase("lineto")) {
                float x = Float.parseFloat(st2.nextToken());
                float y = Float.parseFloat(st2.nextToken());
                pm.addPath(new PathMultiElementLine(x, y));
                continue;
            }
            if (command.equalsIgnoreCase("bezier1")) {
                float x1 = Float.parseFloat(st2.nextToken());
                float y1 = Float.parseFloat(st2.nextToken());
                float x2 = Float.parseFloat(st2.nextToken());
                float y2 = Float.parseFloat(st2.nextToken());
                float x3 = Float.parseFloat(st2.nextToken());
                float y3 = Float.parseFloat(st2.nextToken());
                pm.addPath(new PathMultiElementBezier(x1, y1, x2, y2, x3, y3));
                continue;
            }
            if (command.equalsIgnoreCase("close")) {
                pm.addPath(new PathMultiElementClose());
                continue;
            }
            if (command.equalsIgnoreCase("fill")) {
                pm.addDrawFlag(2);
                int rule = Integer.parseInt(st2.nextToken());
                Color color = this.parseColor(st2);
                pm.setWindingRule(rule);
                pm.setFillColor(color);
                continue;
            }
            if (command.equalsIgnoreCase("stroke")) {
                pm.addDrawFlag(1);
                Color color = this.parseColor(st2);
                float lineWidth = Float.parseFloat(st2.nextToken());
                LineStyle ls = new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st2)));
                pm.setStrokeColor(color);
                pm.setLineStyle(ls);
                continue;
            }
            if (!command.equalsIgnoreCase("shadestroke")) continue;
            pm.addDrawFlag(4);
            String shadeName = st2.nextToken();
            float lineWidth = Float.parseFloat(st2.nextToken());
            LineStyle ls = new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st2)));
            pm.setLineStyle(ls);
            pm.setShading(shadeName);
        }
        return pm;
    }

    protected Path createPolygon(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 10) {
            return null;
        }
        st.nextToken();
        Color color = this.parseColor(st);
        boolean fill = this.parseFill(st);
        int shapeSize = Integer.parseInt(st.nextToken());
        float[] p = new float[shapeSize * 2];
        for (int i = 0; i < shapeSize; ++i) {
            p[i * 2] = Float.parseFloat(st.nextToken());
            p[i * 2 + 1] = Float.parseFloat(st.nextToken());
        }
        float lineWidth = Float.parseFloat(st.nextToken());
        return new PathPolygon(p, new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st))), color, fill);
    }

    protected Path createPolyline(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 9) {
            return null;
        }
        st.nextToken();
        Color color = this.parseColor(st);
        int shapeSize = Integer.parseInt(st.nextToken());
        float[] p = new float[shapeSize * 2];
        for (int i = 0; i < shapeSize; ++i) {
            p[i * 2] = Float.parseFloat(st.nextToken());
            p[i * 2 + 1] = Float.parseFloat(st.nextToken());
        }
        float lineWidth = Float.parseFloat(st.nextToken());
        return new PathPolyline(p, new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st))), color);
    }

    protected Path createRect(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count >= 12) {
            st.nextToken();
            float x1 = Float.parseFloat(st.nextToken());
            float y1 = Float.parseFloat(st.nextToken());
            float x2 = Float.parseFloat(st.nextToken());
            float y2 = Float.parseFloat(st.nextToken());
            Color color = this.parseColor(st);
            boolean fill = this.parseFill(st);
            float lineWidth = Float.parseFloat(st.nextToken());
            return new PathRectangle(x1 < x2 ? x1 : x2, y1 < y2 ? y1 : y2, Math.abs(x2 - x1), Math.abs(y2 - y1), new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st))), color, fill);
        }
        return null;
    }

    protected PathText createText(String s) {
        int start = s.indexOf("#");
        int end = s.lastIndexOf("#");
        if (start < 0 || end < 0 || start == end) {
            return null;
        }
        String str = s.substring(start + 1, end);
        String line = s.substring(end + 1, s.length());
        StringTokenizer st = new StringTokenizer(line, "*");
        int count = st.countTokens();
        if (count < 7 || count > 14 || count == 12) {
            return null;
        }
        float x = Float.parseFloat(st.nextToken());
        float y = Float.parseFloat(st.nextToken());
        String fontName = st.nextToken().trim();
        float fontSize = Float.parseFloat(st.nextToken());
        Color color = this.parseColor(st);
        boolean center = false;
        if (count > 7) {
            boolean bl = center = Float.parseFloat(st.nextToken()) > 0.0f;
        }
        if (count <= 8) {
            return new PathText(str, x, y, fontName, fontSize, color, center);
        }
        int style = Integer.parseInt(st.nextToken());
        if (count <= 9) {
            return new PathText(str, x, y, fontName, fontSize, color, center, style);
        }
        float skew = Float.parseFloat(st.nextToken());
        float rotate = 0.0f;
        if (count > 10) {
            rotate = Float.parseFloat(st.nextToken());
        }
        if (count <= 11) {
            return new PathText(str, x, y, fontName, fontSize, color, center, style, skew, rotate);
        }
        float width = Float.parseFloat(st.nextToken());
        String type = st.nextToken().trim();
        if (count == 13) {
            return new PathText(str, x, y, fontName, fontSize, color, center, style, skew, rotate, width, type);
        }
        boolean embed = Float.parseFloat(st.nextToken()) > 0.0f;
        return new PathText(str, x, y, fontName, fontSize, color, center, style, skew, rotate, width, type, embed);
    }

    protected Path create3D(String s) {
        return null;
    }

    protected float[] parseLinePattern(StringTokenizer token) {
        int count = token.countTokens();
        float[] pattern = new float[count];
        for (int i = 0; i < count; ++i) {
            pattern[i] = Float.parseFloat(token.nextToken());
        }
        return pattern;
    }

    protected Color parseColor(StringTokenizer token) {
        return new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
    }

    protected boolean parseFill(StringTokenizer token) {
        return Integer.parseInt(token.nextToken()) > 0;
    }
}

