/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.awt.Color;
import jp.kitec.lib.util.RefList;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;

public class PathMulti
implements Path {
    public static final int IS_DRAW_PATH = 1;
    public static final int IS_FILL_PATH = 2;
    public static final int IS_SHADE_PATH = 4;
    private int mDrawFlag = 0;
    private int mWindingRule = 8192;
    private LineStyle mLineStyle;
    private Color mStrokeColor;
    private Color mFillColor;
    private RefList mPath = new RefList();
    protected String mPattern;

    public void addDrawFlag(int i) {
        this.mDrawFlag |= i;
    }

    public void setWindingRule(int i) {
        this.mWindingRule = i;
    }

    public void setStrokeColor(Color c) {
        this.mStrokeColor = c;
    }

    public void setFillColor(Color c) {
        this.mFillColor = c;
    }

    public void setLineStyle(LineStyle ltype) {
        this.mLineStyle = ltype;
    }

    public void addPath(Path p) {
        this.mPath.addElement((Object)p);
    }

    @Override
    public boolean draw(Contents con) {
        Path p;
        int i;
        con.setDefaultCoor();
        if ((this.mDrawFlag & 4) > 0 && this.mPattern != null) {
            if (con.getState() != 4) {
                con.saveState(4);
            }
            for (i = 0; i < this.mPath.size(); ++i) {
                p = (Path)this.mPath.elementAt(i);
                p.draw(con);
            }
            con.clipPath();
            con.registerShading(this.mPattern);
            con.shading(this.mPattern);
            con.setStrokeColor(Color.red);
            con.saveState(0);
            if ((this.mDrawFlag & 1) <= 0) {
                return true;
            }
        }
        if ((this.mDrawFlag & 2) > 0) {
            if (con.getState() == 4) {
                if (con.getFillColor() == null || !con.getFillColor().equals(this.mFillColor)) {
                    con.setFillColor(this.mFillColor);
                }
            } else {
                con.saveState(4);
                con.setFillColor(this.mFillColor);
            }
        }
        if ((this.mDrawFlag & 1) > 0) {
            if (con.getState() == 4) {
                if (con.getStrokeColor() == null || !con.getStrokeColor().equals(this.mStrokeColor)) {
                    con.setStrokeColor(this.mStrokeColor);
                }
                if (con.getLStyle() == null || !con.getLStyle().equals(this.mLineStyle)) {
                    con.setLStyle(this.mLineStyle);
                }
            } else {
                con.saveState(4);
                con.setStrokeColor(this.mStrokeColor);
                con.setLStyle(this.mLineStyle);
            }
        }
        for (i = 0; i < this.mPath.size(); ++i) {
            p = (Path)this.mPath.elementAt(i);
            p.draw(con);
        }
        if ((this.mDrawFlag & 1) > 0 && (this.mDrawFlag & 2) > 0) {
            con.fillAndStorokePath(this.mWindingRule == 8192);
        } else if ((this.mDrawFlag & 1) > 0) {
            con.strokePath();
        } else if ((this.mDrawFlag & 2) > 0) {
            con.fillPath(this.mWindingRule == 8192);
        }
        con.saveState(0);
        return true;
    }

    @Override
    public void setPattern(String name) {
    }

    @Override
    public void setShading(String name) {
        this.mPattern = name;
    }
}

