/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.Item;
import option.io.pdfcommon.path.ItemAttribute;
import option.io.pdfcommon.path.PathImage;

public class ItemImage
extends Item {
    protected String mFile;
    protected int[] mImage;
    protected int mWidth;
    protected int mHeight;
    protected PathImage mAttr;

    public ItemImage(String formatName, String itemName, String file, int[] image, int width, int height) {
        super(formatName, itemName);
        this.mFile = file;
        this.mImage = image;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void setAttribute(ItemAttribute attr) {
        Object o = attr.getAttribute();
        if (attr != null && o instanceof PathImage) {
            this.mAttr = (PathImage)o;
            this.mAttr.mImage = this.mImage;
            this.mAttr.mWidth = this.mWidth;
            this.mAttr.mHeight = this.mHeight;
            float orgw = this.mAttr.mOutputWidth;
            float orgh = this.mAttr.mOutputHeight;
            float rateW = this.mAttr.mOutputWidth / this.mAttr.mWidth;
            float rateH = this.mAttr.mOutputHeight / this.mAttr.mHeight;
            if (rateW > rateH) {
                this.mAttr.mOutputWidth = this.mAttr.mWidth * rateH;
                this.mAttr.mX += (orgw - this.mAttr.mOutputWidth) / 2.0f;
            } else if (rateW < rateH) {
                this.mAttr.mOutputHeight = this.mAttr.mHeight * rateW;
                this.mAttr.mY += (orgh - this.mAttr.mOutputHeight) / 2.0f;
            }
        }
    }

    @Override
    public boolean draw(Contents con) {
        if (this.mAttr == null) {
            return true;
        }
        return this.mAttr.draw(con);
    }

    @Override
    public void setPattern(String name) {
    }

    @Override
    public void setShading(String name) {
    }
}

