/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.document.Catalog;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.document.PdfDocumentInfo;
import option.io.pdfcommon.document.RootPages;
import option.io.pdfcommon.document.XrefReference;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.util.PdfRect;

public class Body
extends Vector {
    private PdfDocument document;
    private Catalog catalog;
    private RootPages rootPages;
    private int objectNumber = 1;
    private Page currentPage;
    private Vector pages = new Vector();
    private Hashtable fontCollection;

    public Body(PdfDocument document) {
        this.document = document;
        this.catalog = new Catalog(this);
        this.rootPages = new RootPages(this);
        this.fontCollection = new Hashtable();
        this.add(this.catalog);
        this.add(this.rootPages);
    }

    public PdfFont addFont(PdfFont font) {
        Object ooo = this.fontCollection.get(font.getBaseFont());
        if (ooo == null) {
            Vector descendantFonts;
            int size;
            FontDescriptor fontDescriptor = font.getFontDescriptor();
            if (fontDescriptor != null) {
                this.add(fontDescriptor);
            }
            if ((size = (descendantFonts = font.getDescendantFonts()).size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    this.addFont((CIDFont)descendantFonts.elementAt(i));
                }
            }
            if (font.getCmapStream() != null) {
                this.add(font.getCmapStream());
            }
            if (font.getEmbedFontFile() != null) {
                this.add(font.getEmbedFontFile());
            }
            this.add(font);
            this.fontCollection.put(font.getBaseFont(), font);
            return font;
        }
        return (PdfFont)ooo;
    }

    public RootPages getRootPages() {
        return this.rootPages;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public PdfDocumentInfo getInfo() {
        return this.document.getInfo();
    }

    public void addRootPages(RootPages pages) {
        this.rootPages.addRootPages(pages);
    }

    public void addPage(Page page) {
        this.rootPages.addPage(page);
        int pageIndex = this.pages.size();
        this.pages.add(pageIndex, page);
        this.currentPage = page;
    }

    public void write(PdfOutFile af) {
        for (int i = 0; i < this.size(); ++i) {
            PdfIndirectObject object = (PdfIndirectObject)this.elementAt(i);
            this.document.getXref().addElement(new XrefReference(af.size(), object.getGenerationNumber(), true));
            object.write(af);
        }
    }

    @Override
    public boolean add(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            if (o instanceof PdfIndirectObject) {
                ((PdfIndirectObject)o).setObjectNumber(this.objectNumber);
            }
            ++this.objectNumber;
            this.addElement(o);
            return true;
        }
        Object object = this.elementAt(index);
        if (o instanceof PdfIndirectObject) {
            int objectNumber = ((PdfIndirectObject)object).getObjectNumber();
            int generationNumber = ((PdfIndirectObject)object).getGenerationNumber();
            ((PdfIndirectObject)o).setObjectNumber(objectNumber);
            ((PdfIndirectObject)o).setGenerationNumber(generationNumber);
        }
        return true;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int pageIndex) {
        this.currentPage = (Page)this.pages.elementAt(pageIndex);
    }

    public Page getPageElementAt(int i) {
        return (Page)this.pages.elementAt(i);
    }

    public int getPagesCount() {
        return this.pages.size();
    }

    public Page createPage(PdfRect mediabox) {
        return new Page(this, mediabox);
    }

    public void flush() {
        for (int i = 0; i < this.size(); ++i) {
            Object obj = this.elementAt(i);
            if (obj instanceof Contents) {
                ((Contents)obj).flush();
                continue;
            }
            if (!(obj instanceof FormXObject)) continue;
            ((FormXObject)obj).flush();
        }
    }

    public Hashtable getFontCollection() {
        return this.fontCollection;
    }

    public Pattern search(String name) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            Pattern wp;
            Object o = this.elementAt(i);
            if (!(o instanceof Pattern) || !name.equals((wp = (Pattern)o).getName().getName())) continue;
            return wp;
        }
        return null;
    }
}

