/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfRect {
    private float lux;
    private float luy;
    private float rdx;
    private float rdy;

    public PdfRect() {
    }

    public PdfRect(float lux, float luy, float rdx, float rdy) {
        this.setPoints(lux, luy, rdx, rdy);
    }

    public float getWidth() {
        return this.rdx - this.lux;
    }

    public float getHeight() {
        return this.rdy - this.luy;
    }

    public float getLux() {
        return this.lux;
    }

    public float getLuy() {
        return this.luy;
    }

    public float getRdx() {
        return this.rdx;
    }

    public float getRdy() {
        return this.rdy;
    }

    public void setPoints(float lux, float luy, float rdx, float rdy) {
        this.setLux(lux);
        this.setLuy(luy);
        this.setRdx(rdx);
        this.setRdy(rdy);
    }

    public void setLux(float lux) {
        this.lux = lux;
    }

    public void setLuy(float luy) {
        this.luy = luy;
    }

    public void setRdx(float rdx) {
        this.rdx = rdx;
    }

    public void setRdy(float rdy) {
        this.rdy = rdy;
    }

    public void changeDirection() {
        float tmp = this.rdx;
        this.rdx = this.rdy;
        this.rdy = tmp;
    }

    public void rotate(float angle) {
        float theta = (float)Math.PI * angle / 180.0f;
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        this.lux = cos * this.lux - sin * this.luy;
        this.luy = sin * this.lux + cos * this.luy;
        this.rdx = cos * this.rdx - sin * this.rdy;
        this.rdy = sin * this.rdx + cos * this.rdy;
    }

    public void scale(float x, float y) {
        this.rdx = this.lux + (this.rdx - this.lux) * x;
        this.rdy = this.luy + (this.rdy - this.luy) * y;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[ ");
        pw.print(this.lux);
        pw.print(" ");
        pw.print(this.luy);
        pw.print(" ");
        pw.print(this.rdx);
        pw.print(" ");
        pw.print(this.rdy);
        pw.print(" ]");
        pw.close();
        return sw.toString();
    }

    public void write(PdfOutFile output) {
        PrintStream ps = output.getPrintStream();
        ps.println(this.toString());
    }
}

