/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.util.Vector;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.FormatAttribute;
import option.io.pdfcommon.path.ItemAttribute;
import option.io.pdfcommon.path.Path;

public class Format
implements Path {
    private String mFormatName;
    private String mAbsolutePath;
    private FormatAttribute mAttr;
    private Vector mPaths;

    public Format(String formatName, String absolutePath) {
        this.mFormatName = formatName;
        this.mAbsolutePath = absolutePath;
        this.mPaths = new Vector();
    }

    public void add(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path instanceof FormatAttribute) {
            this.setAttribute((FormatAttribute)path);
        } else {
            this.mPaths.addElement(path);
        }
    }

    public void setAttribute(FormatAttribute attr) {
        this.mAttr = attr;
    }

    public FormatAttribute getAttribute() {
        return this.mAttr;
    }

    public String getFormatName() {
        return this.mFormatName;
    }

    public String getAbsolutePath() {
        return this.mAbsolutePath;
    }

    public ItemAttribute getItemAttribute(String itemName) {
        int i = 0;
        while (i < this.mPaths.size()) {
            ItemAttribute attr;
            Path path = (Path)this.mPaths.elementAt(i);
            if (path instanceof ItemAttribute && (attr = (ItemAttribute)path).getItemName().equals(itemName)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean draw(Contents contents) {
        int i = 0;
        while (i < this.mPaths.size()) {
            Path path = (Path)this.mPaths.elementAt(i);
            path.draw(contents);
            ++i;
        }
        return true;
    }

    @Override
    public void setPattern(String name) {
    }

    @Override
    public void setShading(String name) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Format)) {
            return false;
        }
        Format rhs = (Format)o;
        return this.mFormatName.equals(rhs.mFormatName);
    }
}

