/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class PdfOutFile {
    public static final char SEPARATOR = File.separatorChar;
    public static final String LN = "\r\n";
    private String mPath;
    private String mFileName;
    ByteArrayOutputStream bs = new ByteArrayOutputStream();
    PrintStream ps = new PrintStream(this.bs);
    FileOutputStream fos;

    protected void finalize() throws Throwable {
        try {
            if (this.bs != null) {
                this.bs.close();
            }
            this.bs = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.fos != null) {
                this.fos.close();
            }
            this.fos = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.finalize();
    }

    public byte[] getData() {
        return this.bs.toByteArray();
    }

    public void setData(byte[] data) {
        try {
            this.bs.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ByteArrayOutputStream getByteStream() {
        return this.bs;
    }

    public PrintStream getPrintStream() {
        return this.ps;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fos;
    }

    public void setFileOutputStream(FileOutputStream stream) {
        this.fos = stream;
    }

    public int size() {
        return this.bs.size();
    }

    public void setFile(String file) {
        this.mPath = PdfOutFile.getParent(file);
        this.mFileName = PdfOutFile.getFile(file);
    }

    public String getParent() {
        return this.mPath;
    }

    public String getPath() {
        String path = "";
        if (this.mPath != null) {
            path = String.valueOf(path) + this.mPath + SEPARATOR;
        }
        if (this.mFileName != null) {
            path = String.valueOf(path) + this.mFileName;
        }
        return path;
    }

    public String getName() {
        return this.mFileName;
    }

    public static String getParent(String path) {
        int idx = (path = PdfOutFile.changeSeparator(path)).lastIndexOf(SEPARATOR);
        if (idx >= 0) {
            return path.substring(0, idx);
        }
        return null;
    }

    public static String getFile(String path) {
        int idx = (path = PdfOutFile.changeSeparator(path)).lastIndexOf(SEPARATOR);
        if (idx >= 0 && idx + 1 < path.length() - 1) {
            return path.substring(idx + 1, path.length());
        }
        return path;
    }

    public static String getFileNonExt(String path) {
        if ((path = PdfOutFile.getFile(path)) == null) {
            return null;
        }
        int idx = path.lastIndexOf(".");
        if (idx >= 0 && idx < path.length() - 1) {
            return path.substring(0, idx);
        }
        return null;
    }

    public static String getCreatePath(String path, String file) {
        path = PdfOutFile.changeSeparator(path);
        while (path.lastIndexOf(SEPARATOR) == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        file = PdfOutFile.changeSeparator(file);
        while (file.charAt(0) == SEPARATOR) {
            file = file.substring(1);
        }
        return String.valueOf(path) + SEPARATOR + file;
    }

    public static String changeSeparator(String path) {
        if (SEPARATOR != '/') {
            path = path.replace('/', SEPARATOR);
        } else if (SEPARATOR != '\\') {
            path = path.replace('\\', SEPARATOR);
        }
        return path;
    }

    public void writeToFile() throws IOException {
        this.fos = null;
        try {
            System.out.println(this.getClass().getResource(""));
            this.fos = new FileOutputStream(this.getPath());
            this.bs.writeTo(this.fos);
            System.out.println(this.fos);
        }
        finally {
            if (this.fos != null) {
                this.fos.close();
            }
        }
    }

    public void writeToFile(String fileName) {
        try {
            this.fos = new FileOutputStream(fileName);
            try {
                this.bs.writeTo(this.fos);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                this.fos.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void writeToStream(OutputStream out) {
        try {
            this.bs.writeTo(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.ps.close();
            this.bs.close();
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.ps.flush();
            this.bs.flush();
            if (this.fos != null) {
                this.fos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

