/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Style;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class FontDescriptor
extends PdfIndirectObject
implements DefinedName {
    private PdfDictionary dict = new PdfDictionary();
    private PdfName fontName;
    private EmbedFontFile mEmbedFontFile;

    public FontDescriptor() {
        this.dict.put(TYPE, FONTDESCRIPTOR);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        pw.println(this.dict);
        pw.println("endobj");
        return sw.toString();
    }

    @Override
    public void write(PdfOutFile af) {
        if (this.mEmbedFontFile != null) {
            this.dict.put(FONTFILE2, this.mEmbedFontFile.getReference());
        }
        this.startObject(af);
        this.dict.write(af);
        this.endObject(af);
    }

    public void setAscent(int ascent) {
        this.dict.put(ASCENT, new Integer(ascent));
    }

    public int getAscent() {
        return (Integer)this.dict.get(ASCENT);
    }

    public void setCapHeight(int capHeight) {
        this.dict.put(CAPHEIGHT, new Integer(capHeight));
    }

    public void setDescent(int descent) {
        this.dict.put(DESCENT, new Integer(descent));
    }

    public int getDescent() {
        return (Integer)this.dict.get(DESCENT);
    }

    public void setFlags(int flags) {
        this.dict.put(FLAGS, new Integer(flags));
    }

    public void setFontBBox(PdfRect fontBBox) {
        this.dict.put(FONTBBOX, fontBBox);
    }

    public void setFontName(PdfName fontName) {
        this.fontName = fontName;
        this.dict.put(FONTNAME, fontName);
    }

    public void setItalicAngle(int italicAngle) {
        this.dict.put(ITALICANGLE, new Integer(italicAngle));
    }

    public void setStemV(int stemV) {
        this.dict.put(STEMV, new Integer(stemV));
    }

    public void setAvgWidth(int avgWidth) {
        this.dict.put(AVGWIDTH, new Integer(avgWidth));
    }

    public void setLeading(int leading) {
        this.dict.put(LEADING, new Integer(leading));
    }

    public void setMaxWidth(int maxWidth) {
        this.dict.put(MAXWIDTH, new Integer(maxWidth));
    }

    public void setMissingWidth(int missingWidth) {
        this.dict.put(MISSINGWIDTH, new Integer(missingWidth));
    }

    public void setStemH(int stemH) {
        this.dict.put(STEMH, new Integer(stemH));
    }

    public void setXHeight(int xHeight) {
        this.dict.put(XHEIGHT, new Integer(xHeight));
    }

    public void setCharSet(String charSet) {
        this.dict.put(CHARSET, "(" + charSet + ")");
    }

    public void setStyle(Style style) {
        this.dict.put(STYLE, style);
    }

    public void setLang(PdfName lang) {
        this.dict.put(LANG, lang);
    }

    public void setFontfile2(String r) {
        this.dict.put(FONTFILE2, r);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FontDescriptor font = (FontDescriptor)obj;
        return this.getFontName().equals(font.getFontName());
    }

    public int hashCode() {
        return this.getFontName().hashCode();
    }

    public PdfName getFontName() {
        return this.fontName;
    }

    public EmbedFontFile getMEmbedFontFile() {
        return this.mEmbedFontFile;
    }

    public void setMEmbedFontFile(EmbedFontFile file) {
        this.mEmbedFontFile = file;
    }
}

