/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import d.d;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.AbstFileUtil;
import option.io.pdfcommon.command.PdfCommandImage;
import option.io.pdfcommon.command.PdfCommandImageJpeg;
import option.io.pdfcommon.command.PdfDrawCommandParser;
import option.io.pdfcommon.command.PdfFormatFactory;
import option.io.pdfcommon.command.StreamGobbler;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.PageSize;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.path.Format;
import option.io.pdfcommon.path.Item;
import option.io.pdfcommon.path.ItemAttribute;
import option.io.pdfcommon.path.ItemImage;
import option.io.pdfcommon.path.ItemText;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.Path3D;
import option.io.pdfcommon.path.PathClip;
import option.io.pdfcommon.path.PathGroupPolygon;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathImageJpeg;
import option.io.pdfcommon.path.PathPolygon;
import option.io.pdfcommon.path.PdfDrawer;
import option.io.pdfcommon.util.PdfRect;

public class PdfCommandParser
extends PdfDrawCommandParser {
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected PageSize mPageSize;
    protected PdfDrawer mCmdDrawer;
    protected AbstFile mCmdReader;
    protected BufferedReader mReader;
    protected Map<String, byte[]> mPdfData;
    protected String mFileName;
    protected String mForceFileName;
    protected String mEncoding;
    private String mOutDir;
    private String mTempDir;
    protected boolean mIsCompress = true;
    protected boolean mAllowFormatLoad = false;
    protected static String mIDTFConverter = null;

    public PdfCommandParser(Map<String, byte[]> data, String inDir, String outDir) {
        this(data, inDir, outDir, null);
    }

    public PdfCommandParser(Map<String, byte[]> data, String inDir, String outDir, String tempDir) {
        this(data, inDir, outDir, tempDir, null);
    }

    public PdfCommandParser(Map<String, byte[]> data, String inDir, String outDir, String tempDir, String outFile) {
        super(inDir);
        this.mPdfData = data;
        this.mOutDir = outDir;
        this.mTempDir = tempDir;
        this.mForceFileName = outFile;
        byte[] encodingBytes = this.mPdfData.get("ENCODING");
        String encoding = encodingBytes == null ? null : new String(encodingBytes);
        this.mEncoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public void setAllowFormatLoad(boolean allow) {
        this.mAllowFormatLoad = allow;
    }

    public void setCompressMode(boolean flag) {
        this.mIsCompress = flag;
    }

    public String createPdf() {
        String result = null;
        if (this.mPdfData != null && this.mBase != null) {
            try {
                this.parsePdfCommand();
                if (this.mCmdDrawer.writeToFile()) {
                    this.mCmdDrawer.flush();
                    this.mCmdDrawer.close();
                    result = this.mFileName;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void createPdf(OutputStream out) throws IOException {
        if (this.mPdfData == null || this.mBase == null) {
            throw new IllegalStateException();
        }
        this.parsePdfCommand();
        this.mCmdDrawer.writeToStream(out);
        this.mCmdDrawer.flush();
        this.mCmdDrawer.close();
    }

    public static void loadFormat(File baseDir) {
        PdfCommandParser.loadFormat(baseDir, DEFAULT_ENCODING);
    }

    public static void loadFormat(File baseDir, String encoding) {
        File formatDir = new File(baseDir, "format");
        if (!formatDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = formatDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.endsWith(".fmt")) {
                PdfFormatFactory pff = PdfFormatFactory.getInstance();
                pff.getOrCreateFormat(file, encoding);
            }
            ++n2;
        }
    }

    protected void parsePdfCommand() throws IOException {
        byte[] o = this.mPdfData.get("DATA");
        if (o == null || !(o instanceof byte[])) {
            System.err.println("DATA is null or unsuitable Object");
            throw new IllegalStateException("DATA is null or unsuitable Object");
        }
        if (d.d) {
            this.testDrawCommand("testout.txt", o);
        }
        this.parsePdfCommand(o);
    }

    /*
     * Unable to fully structure code
     */
    private void parsePdfCommand(byte[] data) throws IOException {
        this.mPageSize = new PageSize();
        this.mCmdDrawer = new PdfDrawer();
        this.mCmdReader = new AbstFile();
        this.mCmdReader.setData(data);
        this.mReader = this.mCmdReader.openBufferedReader(this.mEncoding);
        if (this.mReader == null) {
            System.err.println("data from a client cann't be read");
            throw new IOException("data from a client cann't be read");
        }
        block0: while ((s = this.mReader.readLine()) != null) {
            if (s.indexOf("pdfstart") >= 0) ** GOTO lbl27
            continue;
            while ((s = this.mReader.readLine()) != null) {
                if (s.trim().indexOf("#") != 0 && s.indexOf("filestart") >= 0) {
                    st = new StringTokenizer(s, ", ");
                    st.nextToken();
                    this.mFileName = this.mForceFileName;
                    if (this.mFileName == null && st.hasMoreTokens()) {
                        this.mFileName = st.nextToken();
                    }
                    this.mCmdDrawer.openFile(String.valueOf(this.mOutDir) + File.separator + this.mFileName);
                    ss = null;
                    while ((ss = this.mReader.readLine()) != null && ss.indexOf("fileend") < 0) {
                        if (ss.indexOf("pagestart") < 0) continue;
                        this.parsePageCommand(ss);
                    }
                    this.mCmdDrawer.closeFile();
                }
lbl27:
                // 4 sources

                if (s.indexOf("pdfend") < 0) continue;
                continue block0;
            }
        }
        this.mReader.close();
    }

    private void testDrawCommand(String file, byte[] data) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.mBase) + File.separator + file));
            bos.write(data);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parsePageCommand(String pageCmd) throws IOException {
        Vector<Path> paths = new Vector<Path>();
        Vector<Path> formats = new Vector<Path>();
        Vector<Path> items = new Vector<Path>();
        String s = null;
        while ((s = this.mReader.readLine()) != null && s.indexOf("pageend") < 0) {
            Path path;
            if (s.trim().indexOf("[multiline]") == 0) {
                String s2;
                s = "";
                while ((s2 = this.mReader.readLine()) != null && s2.trim().indexOf("[multiline]") != 0) {
                    if (s.length() > 0) {
                        s = String.valueOf(s) + "\r\n";
                    }
                    s = String.valueOf(s) + s2;
                }
            }
            if (s.indexOf("pagesize") >= 0) {
                PdfRect pageSize;
                int dpi;
                StringTokenizer st = new StringTokenizer(s, ", ");
                st.nextToken();
                String size = st.nextToken().trim().toUpperCase();
                int direction = 0;
                if (st.hasMoreElements()) {
                    direction = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreElements() && (dpi = (int)Float.parseFloat(st.nextToken())) > 0) {
                    this.mPageSize.setDpi(dpi);
                }
                if ((pageSize = this.mPageSize.getPageRect(size, direction)) == null) break;
                this.mCmdDrawer.addPage(pageSize);
                this.mCmdDrawer.getNowContents().setFlagCompress(this.mIsCompress);
                continue;
            }
            if (s.indexOf("formstart") >= 0 || (path = this.parseDrawCommand(s)) == null) continue;
            if (path instanceof Format) {
                formats.addElement(path);
                continue;
            }
            if (path instanceof Item) {
                items.addElement(path);
                continue;
            }
            paths.addElement(path);
        }
        this.drawPaths(this.mCmdDrawer.getNowContents(), formats, items, paths);
    }

    @Override
    public Path parseDrawCommand(String command) {
        StringTokenizer st = new StringTokenizer(command, ", ");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String cmd = st.nextToken().trim();
        if (cmd.equals("format")) {
            return this.createFormat(command);
        }
        if (cmd.equals("itemtext")) {
            return this.createItemText(command);
        }
        if (cmd.equals("itemimage")) {
            return this.createItemImage(command);
        }
        if (cmd.equals("grouppolygon")) {
            return this.createGroupPolygon(command);
        }
        if (cmd.equals("pattern")) {
            return this.createPatternedPath(command);
        }
        if (cmd.equals("shading")) {
            return this.createShadingPath(command);
        }
        if (cmd.equals("clip")) {
            return this.createClip(command);
        }
        if (cmd.equals("unclip")) {
            return this.createUnclip(command);
        }
        if (cmd.equals("path")) {
            return this.createMultiPath(command);
        }
        return super.parseDrawCommand(command);
    }

    @Override
    protected PathImage createImage(String s) {
        block5: {
            int[] img;
            float angle;
            float y2;
            float x2;
            float y1;
            float x1;
            float imgH;
            float imgW;
            block7: {
                byte[] obj;
                block6: {
                    StringTokenizer st = new StringTokenizer(s, ", ");
                    int count = st.countTokens();
                    if (count != 9) break block5;
                    st.nextToken();
                    String imgName = st.nextToken();
                    String imgKey = "im" + imgName;
                    imgW = Float.parseFloat(st.nextToken());
                    imgH = Float.parseFloat(st.nextToken());
                    x1 = Float.parseFloat(st.nextToken());
                    y1 = Float.parseFloat(st.nextToken());
                    x2 = Float.parseFloat(st.nextToken());
                    y2 = Float.parseFloat(st.nextToken());
                    angle = Float.parseFloat(st.nextToken());
                    img = null;
                    obj = this.mPdfData.get(imgKey);
                    if (obj != null) break block6;
                    PdfCommandImage pimg = this.getImage(imgName);
                    if (pimg == null) break block7;
                    img = pimg.getPixels();
                    if (imgW <= 0.0f) {
                        imgW = pimg.getWidth();
                    }
                    if (imgH <= 0.0f) {
                        imgH = pimg.getHeight();
                    }
                    if (x2 == x1) {
                        x2 = x1 + imgW * 0.35278347f;
                    }
                    if (y2 != y1) break block7;
                    y2 = y1 - imgH * 0.35278347f;
                    break block7;
                }
                img = new int[obj.length / 4];
                int i = 0;
                while (i < img.length) {
                    img[i] = obj[i * 4] << 24 | obj[i * 4 + 1] << 16 | obj[i * 4 + 2] << 8 | obj[i * 4 + 3] << 0;
                    ++i;
                }
            }
            if (img != null) {
                float x = x1 < x2 ? x1 : x2;
                float y = y1 < y2 ? y1 : y2;
                return new PathImage(img, imgW, imgH, x, y, Math.abs(x2 - x1), Math.abs(y2 - y1), angle);
            }
        }
        return null;
    }

    @Override
    protected Path createJpegImage(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count == 9) {
            st.nextToken();
            String imgName = st.nextToken();
            String imgKey = "im" + imgName;
            float imgW = Float.parseFloat(st.nextToken());
            float imgH = Float.parseFloat(st.nextToken());
            float x1 = Float.parseFloat(st.nextToken());
            float y1 = Float.parseFloat(st.nextToken());
            float x2 = Float.parseFloat(st.nextToken());
            float y2 = Float.parseFloat(st.nextToken());
            float angle = Float.parseFloat(st.nextToken());
            byte[] jpgdata = null;
            PdfCommandImageJpeg pimg = new PdfCommandImageJpeg();
            byte[] obj = this.mPdfData.get(imgKey);
            if (obj == null) {
                pimg.setFile(this.getImagePath(imgName));
                try {
                    pimg.createImageInfo();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                if (x2 == x1) {
                    x2 = x1 + imgW * 0.35278347f;
                }
                if (y2 == y1) {
                    y2 = y1 - imgH * 0.35278347f;
                }
            } else if (obj instanceof byte[]) {
                try {
                    pimg.createImageInfo(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            jpgdata = pimg.getData();
            imgW = pimg.getWidth();
            imgH = pimg.getHeight();
            if (jpgdata != null && imgW > 0.0f && imgH > 0.0f) {
                float x = x1 < x2 ? x1 : x2;
                float y = y1 < y2 ? y1 : y2;
                return new PathImageJpeg(jpgdata, imgW, imgH, x, y, Math.abs(x2 - x1), Math.abs(y2 - y1), angle);
            }
        }
        return null;
    }

    protected Format createFormat(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return null;
        }
        String file = String.valueOf(this.mBase) + File.separator + "format" + File.separator + st.nextToken() + "." + "fmt";
        PdfFormatFactory pff = PdfFormatFactory.getInstance();
        if (this.mAllowFormatLoad) {
            return pff.getOrCreateFormat(file);
        }
        return pff.getFormat(file);
    }

    protected Path createItemText(String s) {
        StringTokenizer st = new StringTokenizer(s, "#");
        st.nextToken();
        String str = st.nextToken();
        String params = st.nextToken().trim();
        st = new StringTokenizer(params, "*");
        if (st.countTokens() != 2) {
            return null;
        }
        String formatName = st.nextToken();
        String itemName = st.nextToken();
        return new ItemText(formatName, itemName, str);
    }

    protected Path createItemImage(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        if (st.countTokens() != 4) {
            return null;
        }
        st.nextToken();
        String file = st.nextToken();
        String formatName = st.nextToken();
        String itemName = st.nextToken();
        PdfCommandImage o = this.getImage(file);
        if (o == null) {
            return null;
        }
        PdfCommandImage pimg = o;
        int[] img = pimg.getPixels();
        if (img == null) {
            return null;
        }
        return new ItemImage(formatName, itemName, file, img, pimg.getWidth(), pimg.getHeight());
    }

    protected Path createGroupPolygon(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 14) {
            return null;
        }
        st.nextToken();
        Color color = this.parseColor(st);
        boolean fill = this.parseFill(st);
        int groupSize = Integer.parseInt(st.nextToken());
        float[][] points = new float[groupSize][];
        int i = 0;
        while (i < groupSize) {
            int shapeSize = Integer.parseInt(st.nextToken());
            float[] p = new float[shapeSize * 2];
            int j = 0;
            while (j < shapeSize) {
                p[j * 2] = Float.parseFloat(st.nextToken());
                p[j * 2 + 1] = Float.parseFloat(st.nextToken());
                ++j;
            }
            points[i] = p;
            ++i;
        }
        float lineWidth = Float.parseFloat(st.nextToken());
        LineStyle line = new LineStyle(lineWidth, new DashPattern(this.parseLinePattern(st)));
        PathGroupPolygon gp = new PathGroupPolygon();
        int i2 = 0;
        while (i2 < groupSize) {
            gp.addPolygon(new PathPolygon(points[i2], line, color, fill));
            ++i2;
        }
        return gp;
    }

    protected Path createPatternedPath(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 3) {
            return null;
        }
        st.nextToken();
        String pattern = st.nextToken();
        int idx = s.indexOf(pattern) + pattern.length() + 1;
        Path p = this.parseDrawCommand(s.substring(idx, s.length()));
        p.setPattern(pattern);
        return p;
    }

    protected Path createShadingPath(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 3) {
            return null;
        }
        st.nextToken();
        String shading = st.nextToken();
        int idx = s.indexOf(shading) + shading.length() + 1;
        Path p = this.parseDrawCommand(s.substring(idx, s.length()));
        p.setShading(shading);
        return p;
    }

    @Override
    protected Path create3D(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count < 11) {
            return null;
        }
        st.nextToken();
        String key = "im" + st.nextToken();
        float lux = Float.parseFloat(st.nextToken());
        float luy = Float.parseFloat(st.nextToken());
        float rdx = Float.parseFloat(st.nextToken());
        float rdy = Float.parseFloat(st.nextToken());
        float borderWidth = Float.parseFloat(st.nextToken());
        Color color = this.parseColor(st);
        float fov = Float.parseFloat(st.nextToken());
        float co = -1.0f;
        if (count > 11) {
            co = Float.parseFloat(st.nextToken());
        }
        byte[] obj = this.mPdfData.get(key);
        AbstFile af = null;
        if (obj != null && obj instanceof byte[]) {
            File u3d;
            block6: {
                try {
                    u3d = this.convertIDTF(obj);
                    if (u3d != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            af = new AbstFile();
            AbstFileUtil.read((AbstFile)af, (File)u3d);
            return new Path3D(af.getData(), lux, luy, rdx, rdy, borderWidth, color, fov, co);
        }
        return null;
    }

    protected Path createClip(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        if (st.countTokens() == 5) {
            st.nextToken();
            float x1 = Float.parseFloat(st.nextToken());
            float y1 = Float.parseFloat(st.nextToken());
            float x2 = Float.parseFloat(st.nextToken());
            float y2 = Float.parseFloat(st.nextToken());
            return new PathClip(x1 < x2 ? x1 : x2, y1 < y2 ? y1 : y2, Math.abs(x2 - x1), Math.abs(y2 - y1));
        }
        return null;
    }

    protected Path createUnclip(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        if (st.countTokens() == 1) {
            return new PathClip();
        }
        return null;
    }

    protected PdfCommandImage getImage(String file) {
        if (file == null) {
            return null;
        }
        return new PdfCommandImage(this.getImagePath(file));
    }

    protected String getImagePath(String file) {
        if (file == null) {
            return null;
        }
        return String.valueOf(this.mBase) + File.separator + IMAGE_DIRECTORY + File.separator + file;
    }

    protected void drawPaths(Contents con, Vector formats, Vector items, Vector paths) {
        this.setAttribute(formats, items);
        int i = 0;
        while (i < formats.size()) {
            ((Format)formats.elementAt(i)).draw(con);
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            ((Item)items.elementAt(i)).draw(con);
            ++i;
        }
        i = 0;
        while (i < paths.size()) {
            ((Path)paths.elementAt(i)).draw(con);
            ++i;
        }
    }

    protected void setAttribute(Vector formats, Vector items) {
        int i = 0;
        while (i < items.size()) {
            Item item = (Item)items.elementAt(i);
            int j = 0;
            while (j < formats.size()) {
                ItemAttribute attr;
                Format format = (Format)formats.elementAt(j);
                if (format.getFormatName().equals(item.getFormatName()) && (attr = format.getItemAttribute(item.getItemName())) != null) {
                    item.setAttribute(attr);
                }
                ++j;
            }
            ++i;
        }
    }

    protected File convertIDTF(byte[] idtf) {
        File tmpOut;
        block6: {
            if (mIDTFConverter == null) {
                this.loadProp();
            }
            if (mIDTFConverter == null || mIDTFConverter.length() == 0) {
                return null;
            }
            File dir = this.mTempDir == null ? new File(this.mOutDir) : new File(this.mTempDir);
            File tmpIn = File.createTempFile("3dAnot-", ".idtf", dir);
            tmpOut = File.createTempFile("3dAnot-", ".u3d", dir);
            FileOutputStream out = new FileOutputStream(tmpIn);
            ((OutputStream)out).write(idtf);
            ((OutputStream)out).close();
            String[] cmd = new String[]{mIDTFConverter, "-input", tmpIn.getAbsolutePath(), "-output", tmpOut.getAbsolutePath()};
            File work = new File(mIDTFConverter).getParentFile();
            Process proc = Runtime.getRuntime().exec(cmd, null, work);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitValue = proc.waitFor();
            if (exitValue == 0) break block6;
            return null;
        }
        try {
            return tmpOut;
        }
        catch (IOException e) {
            throw new RuntimeException("IDTF covnvert exception", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("IDTF convert exception", e);
        }
    }

    protected void loadProp() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("nh3dpdf.properties");
            Properties props = new Properties();
            props.load(inputStream);
            inputStream.close();
            mIDTFConverter = props.getProperty("nh3d.pdf.idtfconverter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

