/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.DeflaterOutputStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObject
extends PdfIndirectObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName name;
    private int width = 1;
    private int height = 1;
    private PdfMetrices mTransMatrices = new PdfMetrices(2);

    public ImageXObject() {
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, IMAGE);
    }

    public ImageXObject(Image img) {
        this();
        if (img != null) {
            this.setImage(img);
        }
    }

    public ImageXObject(int[] pixels, int width, int height) {
        this();
        if (pixels.length > 0 && pixels.length == width * height) {
            this.setImage(pixels, width, height);
        }
    }

    public void setWidth(int width) {
        this.width = width;
        this.dict.put(WIDTH, new Integer(width));
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.dict.put(HEIGHT, new Integer(height));
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void setName(PdfName name) {
        this.name = name;
    }

    @Override
    public void setName(String name) {
        this.setName(new PdfName(name));
    }

    @Override
    public PdfName getName() {
        return this.name;
    }

    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    public void setMTransMatrices(PdfMetrices matrices) {
        this.mTransMatrices = matrices;
    }

    public void setImage(Image image) throws IllegalStateException {
        MediaTracker mt = new MediaTracker(new Canvas());
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < 0 || height < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] pixels = new int[width * height];
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
        this.setImage(pixels, width, height);
    }

    protected void setImage(int[] pixels, int width, int height) {
        this.setEntries();
        this.setWidth(width);
        this.setHeight(height);
        this.stream = new PdfStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(this.stream);
        DataOutputStream ds = new DataOutputStream(dos);
        byte[] buf = new byte[3072];
        int count = 0;
        int line = 0;
        ColorModel defaultRGB = ColorModel.getRGBdefault();
        try {
            try {
                int j = 0;
                while (j < height) {
                    line = j * width;
                    int i = 0;
                    while (i < width) {
                        int pixel = pixels[i + line];
                        buf[count++] = (byte)defaultRGB.getRed(pixel);
                        buf[count++] = (byte)defaultRGB.getGreen(pixel);
                        buf[count++] = (byte)defaultRGB.getBlue(pixel);
                        if (count >= buf.length) {
                            ds.write(buf, 0, count);
                            count = 0;
                        }
                        ++i;
                    }
                    ++j;
                }
                if (count > 0) {
                    ds.write(buf, 0, count);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    dos.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void setEntries() {
        this.dict.put(COLORSPACE, DEVICERGB);
        this.dict.put(BITSPERCOMPONENT, 8);
        this.dict.put(FILTER, FLATEDECODE);
        this.dict.put(INTERPOLATE, Boolean.TRUE);
    }

    @Override
    public void write(PdfOutFile output) {
        try {
            this.dict.put(LENGTH, new Integer(this.stream.size()));
            PrintStream ps = output.getPrintStream();
            this.startObject(output);
            ps.println(this.dict);
            ps.println("stream");
            this.stream.writeTo(output.getByteStream());
            ps.println("endstream");
            this.endObject(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

