/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.function;

import java.util.Vector;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.function.Function;

public class FunctionType3
extends Function {
    private float[] mBounds;
    private float[] mEncode;
    private Vector mFunctions = new Vector();

    public FunctionType3(Body body) {
        super(body, 3);
    }

    public void setBounds(float[] bounds) {
        this.mBounds = bounds;
    }

    public void setEncode(float[] encode) {
        this.mEncode = encode;
    }

    public void addFunction(Function f) {
        this.mFunctions.addElement(f);
    }

    @Override
    public void updateDict() {
        super.updateDict();
        String s = this.toArrayString(this.mBounds, true);
        if (s != null) {
            this.dict.put(BOUNDS, s);
        }
        if ((s = this.toArrayString(this.mEncode, true)) != null) {
            this.dict.put(ENCODE, s);
        }
        if ((s = this.toFunctionsString()) != null) {
            this.dict.put(FUNCTIONS, s);
        }
    }

    protected String toFunctionsString() {
        int sz = this.mFunctions.size();
        if (sz < 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer("[");
        Function f = (Function)this.mFunctions.elementAt(0);
        sb.append(f.getReference());
        int i = 1;
        while (i < sz) {
            sb.append(" ");
            f = (Function)this.mFunctions.elementAt(i);
            sb.append(f.getReference());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

