/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class HheaTable
extends TTFTable {
    public int ascent;
    public int descent;
    public int numOfLongHorMetrics;

    public HheaTable() {
        this.tableName = "hhea";
    }

    @Override
    public void loadFontData(TrueTypeFontFileReader fr) {
        try {
            fr.seek(this.offset);
            fr.skipBytes(4);
            this.ascent = fr.readFWord();
            this.descent = fr.readFWord();
            fr.skipBytes(26);
            this.numOfLongHorMetrics = fr.readUInt16();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "[ Class: HheaTable  ascent: " + this.ascent + "  descent: " + this.descent + "  numOfLongHorMetrics: " + this.numOfLongHorMetrics + " ]";
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getNumOfLongHorMetrics() {
        return this.numOfLongHorMetrics;
    }
}

