/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class CharProc
extends Contents {
    private CharProc[] charDefList = new CharProc[256];
    private int firstChar = this.charDefList.length - 1;
    private int lastChar = 0;
    protected Body mBody;
    private PdfDictionary charDefs = new PdfDictionary();
    private PdfArray widths = new PdfArray();
    private PdfArray differences = new PdfArray();
    private PdfName name = new PdfName("CP1");

    public CharProc(Body body, PdfRect mediabox, String name) {
        this.mBody = body;
        this.mediabox = mediabox;
        this.stream = new PdfStream();
        this.mPrintStream = this.stream.getPrintStream();
        this.setName(name);
        this.setD1(1000, 0, mediabox.getLux(), mediabox.getLuy(), mediabox.getRdx(), mediabox.getRdy());
    }

    public void setName(String name) {
        this.name = new PdfName(name);
    }

    public void setD1(float wx, float wy, float llx, float lly, float urx, float ury) {
        this.mPrintStream.println(String.valueOf(wx) + " " + 0 + " " + llx + " " + lly + " " + urx + " " + ury + " d1");
    }

    public void setD1(int wx, int wy, float llx, float lly, float urx, float ury) {
        this.setD1((float)wx, (float)wy, llx, lly, urx, ury);
    }

    public PdfName getName() {
        return this.name;
    }

    public void setcharDef(CharProc charDef, char code) {
        this.mBody.add(charDef);
        int c = String.valueOf(code).getBytes()[0];
        this.charDefList[c] = charDef;
        if (c < this.firstChar) {
            this.firstChar = c;
        }
        if (c > this.lastChar) {
            this.lastChar = c;
        }
    }

    public PdfDictionary getcharDefs() {
        return this.charDefs;
    }

    public PdfArray getWidths() {
        return this.widths;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public void init() {
        this.differences.removeAllElements();
        this.widths.removeAllElements();
        boolean isDefined = false;
        int i = this.firstChar;
        while (i <= this.lastChar) {
            if (this.charDefList[i] != null) {
                CharProc charDef = this.charDefList[i];
                this.widths.addElement(new Integer(1000));
                if (!isDefined) {
                    this.differences.addElement(new Integer(i));
                    isDefined = true;
                }
                this.differences.addElement(charDef.getName());
                this.charDefs.put(charDef.getName(), charDef.getReference());
            } else {
                this.widths.addElement(new Integer(0));
                isDefined = false;
            }
            ++i;
        }
    }
}

