/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.util.Vector;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfArray;

public class RootPages
extends DictObj {
    private Vector kidsList = new Vector();
    private RootPages parent = null;

    public RootPages(Body body) {
        super(body);
        this.dict.put(TYPE, PAGES);
    }

    private void setParent(RootPages parent) {
        this.parent = parent;
    }

    public void addRootPages(RootPages pages) {
        this.body.add(pages);
        pages.setParent(this);
        this.kidsList.addElement(pages);
    }

    public void addPage(Page page) {
        this.body.add(page);
        page.setParent(this);
        this.kidsList.addElement(page);
    }

    private int getCount() {
        int count = 0;
        int i = 0;
        while (i < this.kidsList.size()) {
            Object object = this.kidsList.elementAt(i);
            if (object instanceof RootPages) {
                count += ((RootPages)object).getCount();
            } else if (object instanceof Page) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public void updateDict() {
        this.dict.put(COUNT, new Integer(this.getCount()));
        if (this.parent != null) {
            this.dict.put(PARENT, this.parent.getReference());
        }
        PdfArray kidsArray = new PdfArray();
        int i = 0;
        while (i < this.kidsList.size()) {
            Object object = this.kidsList.elementAt(i);
            if (object instanceof RootPages) {
                kidsArray.addElement(((RootPages)object).getReference());
            } else if (object instanceof Page) {
                kidsArray.addElement(((Page)object).getReference());
            }
            ++i;
        }
        this.dict.put(KIDS, kidsArray.toString());
    }
}

