/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.EmbedU3DFile;
import option.io.pdfcommon.document.PdfAction;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;
import option.io.pdfcommon.util.PdfUtil;

public class PdfAnnotation
extends DictObj {
    private PdfName mySubType;
    private PdfRect rec;
    private PdfUtil mPdfUtil = new PdfUtil();

    public PdfAnnotation(Body body) {
        super(body);
        this.dict.put(TYPE, ANNOT);
    }

    @Override
    public void updateDict() {
        this.dict.put(SUBTYPE, this.mySubType);
        this.dict.put(RECT, this.rec);
    }

    public PdfAnnotation createURILink(Body inBody, String url, PdfRect rec) {
        PdfAction adLink = new PdfAction().getLinkActionDictionary(url);
        PdfAnnotation repa = new PdfAnnotation(inBody);
        repa.mySubType = LINK;
        repa.rec = rec;
        repa.dict.put(A, adLink);
        return repa;
    }

    public PdfAnnotation createLink(Body inBody, String url, PdfRect rec, float border) {
        PdfAnnotation repa = new PdfAnnotation(inBody);
        PdfAction adLink = new PdfAction().getLinkActionDictionary(url);
        adLink.parentSubTypeName = LINK;
        repa.mySubType = LINK;
        repa.rec = rec;
        PdfArray pa = new PdfArray();
        if (border > 0.0f) {
            pa.addElement(new Integer(0));
            pa.addElement(new Integer(0));
            pa.addElement(new Float(border));
        } else {
            pa.addElement(new Integer(0));
            pa.addElement(new Integer(0));
            pa.addElement(new Float(0.0f));
        }
        repa.dict.put(BORDER, pa);
        repa.dict.put(A, adLink);
        return repa;
    }

    public PdfAnnotation create3D(Body inBody, EmbedU3DFile url, PdfRect rec, FormXObject form, float border, Color background, float fov, float co) {
        PdfAnnotation repa = new PdfAnnotation(inBody);
        repa.mySubType = _3D;
        repa.rec = rec;
        PdfArray pa = new PdfArray();
        if (border > 0.0f) {
            pa.addElement(new Integer(0));
            pa.addElement(new Integer(0));
            pa.addElement(new Float(border));
        } else {
            pa.addElement(new Integer(0));
            pa.addElement(new Integer(0));
            pa.addElement(new Float(0.0f));
        }
        repa.dict.put(BORDER, pa);
        repa.dict.put(_3DD, url.getReference());
        repa.dict.put(_3DI, "true");
        PdfDictionary dicap = new PdfDictionary();
        dicap.put(N, form.getReference());
        repa.dict.put(AP, dicap);
        PdfDictionary dicp = new PdfDictionary();
        if (fov == 0.0f) {
            dicp.put(SUBTYPE, O);
        } else {
            dicp.put(SUBTYPE, P);
            dicp.put(FOV, this.mPdfUtil.formatPrint(fov));
        }
        dicp.put(PS, MIN);
        PdfDictionary dic3dv = new PdfDictionary();
        dic3dv.put(MS, U3D);
        dic3dv.put(U3DPATH, "(DefaultView)");
        if (co > 0.0f) {
            dic3dv.put(CO, Float.valueOf(co));
        }
        dic3dv.put(P, dicp);
        dic3dv.put(XN, "(Default)");
        dic3dv.put(BG, "<</CS/DeviceRGB/C[" + this.mPdfUtil.formatPrint((float)background.getRed() / 255.0f) + " " + this.mPdfUtil.formatPrint((float)background.getGreen() / 255.0f) + " " + this.mPdfUtil.formatPrint((float)background.getBlue() / 255.0f) + "]>>");
        PdfDictionary dicRenderMode = new PdfDictionary();
        dicRenderMode.put(TYPE, new PdfName("3DRenderMode"));
        dicRenderMode.put(SUBTYPE, new PdfName("SolidOutline"));
        dic3dv.put(RM, dicRenderMode);
        repa.dict.put(_3DV, dic3dv);
        PdfDictionary dic3da = new PdfDictionary();
        dic3da.put(A, PO);
        dic3da.put(AIS, I);
        dic3da.put(D, PI);
        dic3da.put(DIS, I);
        repa.dict.put(_3DA, dic3da);
        return repa;
    }
}

