/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import d.d;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.kitec.lib.util.RefList;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.EmbedU3DFile;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PdfAnnotation;
import option.io.pdfcommon.document.Resources;
import option.io.pdfcommon.font.BaseJapanNoEmbedFont;
import option.io.pdfcommon.font.FontFactory;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFont;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.ImageXObjectJpeg;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.StreamObj;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;
import option.io.pdfcommon.pattern.ShadingType2;
import option.io.pdfcommon.pattern.TilingPattern;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;
import option.io.pdfcommon.util.PdfUtil;

public class Contents
extends StreamObj
implements PdfDataConst {
    public static final int STATE_NONE = 0;
    public static final int STATE_TEXT = 1;
    public static final int STATE_IMAGE = 2;
    public static final int STATE_FORM = 3;
    public static final int STATE_GRAPH = 4;
    public static final int STATE_DEFAULT = 0;
    public static final float DEFAULT_CHAR_SPACING = 0.0f;
    public static final float DEFAULT_CHAR_SCALING = 100.0f;
    private int mState;
    private PdfMetrices mTextMetrices = new PdfMetrices(1);
    private Color mFillColor;
    private Color mStrokeColor;
    protected Body mBody;
    private Page parentPage;
    protected PdfRect mediabox;
    protected PrintStream mPrintStream;
    protected boolean isFontChanged = false;
    protected Resources resources;
    private LineStyle mLineStyle = null;
    private BaseJapanNoEmbedFont bjf = new BaseJapanNoEmbedFont();
    private PdfFont mFont;
    private float mCurrentMatrixA;
    private float mCurrentMatrixB;
    private float mCurrentMatrixC;
    private float mCurrentMatrixD;
    private float mCurrentMatrixE;
    private float mCurrentMatrixF;
    private int mCurrentFontStyle;
    private float mCurrentCharSpacing;
    private float mCurrentCharScaling;
    private PdfUtil mPdfUtil;
    private PdfRect mClipRect;
    private Hashtable mUsingEmbededFonts;

    public Contents() {
        this.mFont = this.bjf.DEFAULT_FONT;
        this.mCurrentMatrixA = 1.0f;
        this.mCurrentMatrixB = 0.0f;
        this.mCurrentMatrixC = 0.0f;
        this.mCurrentMatrixD = 1.0f;
        this.mCurrentMatrixE = 0.0f;
        this.mCurrentMatrixF = 0.0f;
        this.mCurrentFontStyle = 0;
        this.mCurrentCharSpacing = 0.0f;
        this.mCurrentCharScaling = 100.0f;
        this.mPdfUtil = new PdfUtil();
        this.mUsingEmbededFonts = new Hashtable();
        this.flagStreamCompress = false;
        this.mPrintStream = this.stream.getPrintStream();
        this.mFont.setSize(4.233402f);
    }

    public Contents(Body body, PdfRect mediabox) {
        this();
        this.mBody = body;
        this.resources = new Resources(body);
        this.mediabox = mediabox;
        this.parentPage = body.getCurrentPage();
        this.pageCoor();
    }

    protected void finalize() throws Throwable {
        if (d.d) {
            System.out.println(String.valueOf(this.getClass().toString()) + " finalized!");
        }
        super.finalize();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        pw.println(this.dict);
        pw.println("stream");
        pw.println(this.stream);
        pw.println("endstream");
        pw.println("endobj");
        return sw.toString();
    }

    public void setFillColor(Color color) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (color != null) {
            r = (float)color.getRed() / 255.0f;
            g = (float)color.getGreen() / 255.0f;
            b = (float)color.getBlue() / 255.0f;
        }
        this.setFillColor(r, g, b);
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(float r, float g, float b) {
        Color color = new Color(r, g, b);
        if (this.mFillColor != null && this.mFillColor.equals(color)) {
            return;
        }
        this.mFillColor = color;
        if (r == g && g == b) {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(r)) + " g");
        } else {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(r)) + " " + this.mPdfUtil.formatPrint(g) + " " + this.mPdfUtil.formatPrint(b) + " rg");
        }
    }

    public void setStrokeColor(Color color) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (color != null) {
            r = (float)color.getRed() / 255.0f;
            g = (float)color.getGreen() / 255.0f;
            b = (float)color.getBlue() / 255.0f;
        }
        this.setStrokeColor(r, g, b);
    }

    public Color getStrokeColor() {
        return this.mStrokeColor;
    }

    public void setStrokeColor(float r, float g, float b) {
        Color color = new Color(r, g, b);
        if (this.mStrokeColor != null && this.mStrokeColor.equals(color)) {
            return;
        }
        this.mStrokeColor = color;
        if (r == g && g == b) {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(r)) + " G");
        } else {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(r)) + " " + this.mPdfUtil.formatPrint(g) + " " + this.mPdfUtil.formatPrint(b) + " RG");
        }
    }

    public void setFillGray(float g) {
        if ((double)g >= 0.0 && (double)g <= 1.0) {
            this.setFillColor(g, g, g);
        }
    }

    public void setStrokeGray(float g) {
        if ((double)g >= 0.0 && (double)g <= 1.0) {
            this.setStrokeColor(g, g, g);
        }
    }

    public void setLStyle(LineStyle style) {
        this.mLineStyle = style != null ? style : new LineStyle();
        this.mPrintStream.println(this.mLineStyle.toString());
    }

    public void setLineWidth(float width) {
        this.mPrintStream.println(String.valueOf(width) + " w");
    }

    private void cm(float a, float b, float c, float d2, float e, float f) {
        if (this.mCurrentMatrixA != a || this.mCurrentMatrixB != b || this.mCurrentMatrixC != c || this.mCurrentMatrixD != d2 || this.mCurrentMatrixE != e || this.mCurrentMatrixF != f) {
            float det = 1.0f / (this.mCurrentMatrixA * this.mCurrentMatrixD - this.mCurrentMatrixB * this.mCurrentMatrixC);
            float ra = this.mCurrentMatrixD * det;
            float rb = -this.mCurrentMatrixB * det;
            float rc = -this.mCurrentMatrixC * det;
            float rd = this.mCurrentMatrixA * det;
            float re = (this.mCurrentMatrixC * this.mCurrentMatrixF - this.mCurrentMatrixD * this.mCurrentMatrixE) * det;
            float rf = (this.mCurrentMatrixB * this.mCurrentMatrixE - this.mCurrentMatrixA * this.mCurrentMatrixF) * det;
            this.writeCurrentTransformationMatrix(ra, rb, rc, rd, re, rf);
            this.mCurrentMatrixA = a;
            this.mCurrentMatrixB = b;
            this.mCurrentMatrixC = c;
            this.mCurrentMatrixD = d2;
            this.mCurrentMatrixE = e;
            this.mCurrentMatrixF = f;
            this.writeCurrentTransformationMatrix(a, b, c, d2, e, f);
        }
    }

    private void writeCurrentTransformationMatrix(float a, float b, float c, float d2, float e, float f) {
        if (a == 1.0f && Math.abs(b) == 0.0f && Math.abs(c) == 0.0f && d2 == 1.0f && Math.abs(e) == 0.0f && Math.abs(f) == 0.0f) {
            return;
        }
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(a, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(b, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(c, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(d2, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(e, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f, 4)) + " ");
        this.mPrintStream.println("cm");
    }

    private void identityCM() {
        this.mCurrentMatrixA = 1.0f;
        this.mCurrentMatrixB = 0.0f;
        this.mCurrentMatrixC = 0.0f;
        this.mCurrentMatrixD = 1.0f;
        this.mCurrentMatrixE = 0.0f;
        this.mCurrentMatrixF = 0.0f;
    }

    public void translate(float x, float y) {
        this.cm(1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public void scale(float x, float y) {
        this.cm(0.0f, 0.0f, 0.0f, 0.0f, x, y);
    }

    public void rotate(float angle) {
        double rad = (double)angle * Math.PI / 180.0;
        this.cm((float)Math.cos(rad), (float)Math.sin(rad), -((float)Math.sin(rad)), (float)Math.cos(rad), 0.0f, 0.0f);
    }

    public void pageCoor() {
        this.writeCurrentTransformationMatrix(2.8346f, 0.0f, 0.0f, 2.8346f, 0.0f, 0.0f);
    }

    public void setDefaultCoor() {
        this.cm(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public void setFont(PdfFont font) {
        if (this.mFont != (font = this.mBody.addFont(font))) {
            this.isFontChanged = true;
            this.mFont = font;
        }
        this.resources.addFont(font);
    }

    private void setFont(String fn, int style) {
        PdfFont pf = this.bjf.getDefinedFont(fn);
        if (pf == null) {
            pf = this.bjf.getBaseFont(fn);
        }
        this.setFont(pf);
    }

    public PdfFont getFont() {
        return this.mFont;
    }

    public void setFontSize(float size) {
        if (this.mFont != null && this.mFont.getSize() != size) {
            this.isFontChanged = true;
            this.mFont.setSize(size);
        }
    }

    public int getState() {
        return this.mState;
    }

    public void saveState(int state) {
        if (state == this.mState) {
            return;
        }
        this.loadState();
        if (this.mClipRect != null) {
            this.saveGraphicsState();
            this.clipRect();
        }
        switch (state) {
            case 1: {
                this.beginText();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.mClipRect != null) break;
                this.saveGraphicsState();
            }
        }
        this.mState = state;
    }

    private void loadState() {
        switch (this.mState) {
            case 1: {
                this.endText();
                if (this.mClipRect == null) break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.loadGraphicsState();
            }
        }
        this.mStrokeColor = null;
        this.mFillColor = null;
        this.mState = 0;
    }

    public void endContents() {
        this.loadState();
        this.closeUsingEmbededFonts();
    }

    private void closeUsingEmbededFonts() {
        if (d.d) {
            System.out.println("close called!");
        }
        Enumeration e = this.mUsingEmbededFonts.elements();
        TrueTypeFont ttf = null;
        try {
            while (e.hasMoreElements()) {
                ttf = (TrueTypeFont)e.nextElement();
                ttf.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("**** FontFile=" + ttf.fontFileName);
            ioe.printStackTrace();
        }
        this.mUsingEmbededFonts.clear();
    }

    private void saveGraphicsState() {
        this.mPrintStream.println("q");
    }

    private void loadGraphicsState() {
        this.mPrintStream.println("Q");
        this.mPrintStream.println();
        this.mFillColor = null;
        this.mStrokeColor = null;
        this.mLineStyle = null;
        this.identityCM();
    }

    public void closePath() {
        this.mPrintStream.println("h");
    }

    public void strokePath() {
        this.mPrintStream.println("S");
    }

    public void closeAndStrokePath() {
        this.mPrintStream.println("s");
    }

    public void fillAndStorokePath(boolean wind_non_zero) {
        this.mPrintStream.println("b" + (wind_non_zero ? "" : "*"));
    }

    public void fillPath() {
        this.fillPath(true);
    }

    private void fillPathUsingOddEvenRule() {
        this.fillPath(false);
    }

    public void fillPath(boolean wind_non_zero) {
        this.mPrintStream.println("f" + (wind_non_zero ? "" : "*"));
    }

    public Resources getResources() {
        return this.resources;
    }

    private void drawForm(FormXObject form, float x, float y, float width, float height) {
        this.mBody.add(form);
        this.resources.addXObject(form);
        this.saveState(3);
        float sx = width / form.getWidth();
        float sy = height / form.getHeight();
        float scale = sx < sy ? sx : sy;
        form.getMTransMatrices().setTranslation(x, y);
        form.getMTransMatrices().setScale(scale, scale);
        this.mPrintStream.println(form.getMTransMatrices().toString());
        this.mPrintStream.println(form.getName() + " Do");
        this.loadState();
    }

    private void imageDrawer(ImageXObject image, float x, float y, float width, float height) {
        PdfName imageName = image.getName();
        if (imageName == null) {
            imageName = new PdfName("Im" + String.valueOf(this.mBody.size() + 1));
            image.setName(imageName);
        } else {
            this.resources.getXObjectDictionary().containsKey(imageName);
        }
        this.saveState(2);
        this.mBody.add(image);
        this.resources.addXObject(image);
        this.resources.useImageC();
        image.getMTransMatrices().setTranslation(x, y);
        image.getMTransMatrices().setScale(width, height);
        this.mPrintStream.print(image.getMTransMatrices().toString());
        this.mPrintStream.println(image.getName() + " Do");
        this.loadState();
    }

    public void beginPath(float x, float y) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(x));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(y));
        this.mPrintStream.println(" m");
    }

    public void linePath(float x, float y) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(x));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(y));
        this.mPrintStream.println(" l");
    }

    private void rectanglePath(float x, float y, float width, float height) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(x));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(y));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(width));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(height));
        this.mPrintStream.println(" re");
    }

    private void ellipsePath(float cx, float cy, float r, float h) {
        this.translate(cx, cy);
        double[] x = new double[5];
        double[] y = new double[5];
        double theta = 1.0471975511965976;
        double cos = Math.cos(1.0471975511965976);
        double sin = Math.sin(1.0471975511965976);
        x[2] = 1.0;
        x[1] = 1.0;
        y[1] = 0.0;
        x[4] = cos;
        y[4] = sin;
        x[3] = (8.0 * Math.cos(0.5235987755982988) - (x[1] + 3.0 * x[2] + x[4])) / 3.0;
        y[3] = y[4] - (-x[3] + x[4]) / -Math.tan(1.0471975511965976);
        y[2] = (8.0 * Math.sin(0.5235987755982988) - (y[1] + 3.0 * y[3] + y[4])) / 3.0;
        double[] xtmp = new double[5];
        double[] ytmp = new double[5];
        this.beginPath((float)((double)r * x[1]), (float)(y[1] * (double)h));
        int i = 0;
        while (i < 6) {
            this.cubicBezierPath((float)((double)r * x[2]), (float)(y[2] * (double)h), (float)((double)r * x[3]), (float)(y[3] * (double)h), (float)((double)r * x[4]), (float)(y[4] * (double)h));
            int j = 2;
            while (j <= 4) {
                xtmp[j] = x[j] * cos - y[j] * sin;
                ytmp[j] = x[j] * sin + y[j] * cos;
                x[j] = xtmp[j];
                y[j] = ytmp[j];
                ++j;
            }
            ++i;
        }
        this.closePath();
    }

    private void circlePath(float cx, float cy, float r) {
        this.translate(cx, cy);
        double theta = 1.0471975511965976;
        double cos = Math.cos(1.0471975511965976);
        double sin = Math.sin(1.0471975511965976);
        double[] x = new double[5];
        double[] y = new double[5];
        x[2] = 1.0;
        x[1] = 1.0;
        y[1] = 0.0;
        x[4] = cos;
        y[4] = sin;
        x[3] = (8.0 * Math.cos(0.5235987755982988) - (x[1] + 3.0 * x[2] + x[4])) / 3.0;
        y[3] = y[4] - (-x[3] + x[4]) / -Math.tan(1.0471975511965976);
        y[2] = (8.0 * Math.sin(0.5235987755982988) - (y[1] + 3.0 * y[3] + y[4])) / 3.0;
        this.beginPath((float)((double)r * x[1]), (float)(y[1] * (double)r));
        double[] xtmp = new double[5];
        double[] ytmp = new double[5];
        int i = 0;
        while (i < 6) {
            this.cubicBezierPath((float)((double)r * x[2]), (float)(y[2] * (double)r), (float)((double)r * x[3]), (float)(y[3] * (double)r), (float)((double)r * x[4]), (float)(y[4] * (double)r));
            int j = 2;
            while (j <= 4) {
                xtmp[j] = x[j] * cos - y[j] * sin;
                ytmp[j] = x[j] * sin + y[j] * cos;
                x[j] = xtmp[j];
                y[j] = ytmp[j];
                ++j;
            }
            ++i;
        }
        this.closePath();
    }

    private void arcPath(float cx, float cy, float r, float h, float startAngle, float arcAngle, boolean isFilled) {
        if (arcAngle <= 0.0f) {
            return;
        }
        this.translate(cx, cy);
        float width = r * 2.0f;
        float height = h * 2.0f;
        double ath = (double)arcAngle * Math.PI / 180.0;
        double theta = ath / 6.0;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double[] x = new double[5];
        double[] y = new double[5];
        x[2] = 1.0;
        x[1] = 1.0;
        y[1] = 0.0;
        x[4] = cos;
        y[4] = sin;
        x[3] = (8.0 * Math.cos(theta / 2.0) - (x[1] + 3.0 * x[2] + x[4])) / 3.0;
        y[3] = y[4] - (-x[3] + x[4]) / -Math.tan(theta);
        y[2] = (8.0 * Math.sin(theta / 2.0) - (y[1] + 3.0 * y[3] + y[4])) / 3.0;
        double stheta = (double)startAngle * Math.PI / 180.0;
        double scos = Math.cos(stheta);
        double ssin = Math.sin(stheta);
        double[] xtmp = new double[5];
        double[] ytmp = new double[5];
        int j = 1;
        while (j <= 4) {
            xtmp[j] = x[j] * scos - y[j] * ssin;
            ytmp[j] = x[j] * ssin + y[j] * scos;
            x[j] = xtmp[j];
            y[j] = ytmp[j];
            ++j;
        }
        float aspect = height / width;
        if (Float.isNaN(aspect)) {
            aspect = 1.0f;
        }
        if (isFilled) {
            this.beginPath(0.0f, 0.0f);
            this.linePath((float)((double)r * x[1]), (float)((double)r * y[1]) * aspect);
        } else {
            this.beginPath((float)((double)r * x[1]), (float)((double)r * y[1]) * aspect);
        }
        int i = 0;
        while (i < 6) {
            this.cubicBezierPath((float)((double)r * x[2]), (float)((double)r * y[2]) * aspect, (float)((double)r * x[3]), (float)((double)r * y[3]) * aspect, (float)((double)r * x[4]), (float)((double)r * y[4]) * aspect);
            int j2 = 2;
            while (j2 <= 4) {
                xtmp[j2] = x[j2] * cos - y[j2] * sin;
                ytmp[j2] = x[j2] * sin + y[j2] * cos;
                x[j2] = xtmp[j2];
                y[j2] = ytmp[j2];
                ++j2;
            }
            ++i;
        }
        if (isFilled) {
            this.closePath();
        }
    }

    private void arrayPolyPath(float[] p) {
        if (p.length < 2 || p.length % 2 != 0) {
            return;
        }
        this.beginPath(p[0], p[1]);
        int i = 2;
        while (i < p.length) {
            this.linePath(p[i], p[i + 1]);
            i += 2;
        }
    }

    private void reflistPath(RefList p) {
        if (p.size() < 2) {
            return;
        }
        Object o = p.elementAt(0);
        if (o instanceof Point) {
            Point pp = (Point)o;
            this.beginPath(pp.x, pp.y);
        }
        int i = 1;
        while (i < p.size()) {
            o = p.elementAt(i);
            if (o instanceof Point) {
                Point pp = (Point)o;
                this.linePath(pp.x, pp.y);
            }
            ++i;
        }
    }

    private void polyPath(Polygon p) {
        this.beginPath(p.xpoints[0], p.ypoints[0]);
        int i = 1;
        while (i < p.npoints) {
            this.linePath(p.xpoints[i], p.ypoints[i]);
            ++i;
        }
    }

    public void cubicBezierPath(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(x1)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(y1)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(x2)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(y2)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(x3)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(y3)) + " ");
        this.mPrintStream.println("c");
    }

    public int[] color2RGB(Color color) {
        int[] rgb = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        return rgb;
    }

    public LineStyle getLStyle() {
        return this.mLineStyle;
    }

    public boolean isFlagCompress() {
        return this.flagStreamCompress;
    }

    public void setFlagCompress(boolean b) {
        this.flagStreamCompress = b;
    }

    public PdfRect getMediabox() {
        return this.mediabox;
    }

    public void writeLine(float x1, float y1, float x2, float y2, Object ltype, Color c) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                this.setStrokeColor(c);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                this.setLStyle((LineStyle)ltype);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(c);
            this.setLStyle((LineStyle)ltype);
        }
        this.beginPath(x1, y1);
        this.linePath(x2, y2);
        this.strokePath();
    }

    public void writeRectangle(float x, float y, float width, float height, Object ltype, Color c, boolean isFill) {
        this.setDefaultCoor();
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.rectanglePath(x, y, width, height);
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.rectanglePath(x, y, width, height);
            this.strokePath();
        }
    }

    public void writeArc(float x, float y, float r, float h, float start, float angle, Object ltype, Color c, boolean isFill) {
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.arcPath(x, y, r, h, start, angle, isFill);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.arcPath(x, y, r, h, start, angle, isFill);
            this.strokePath();
        }
    }

    public void writeEllipse(float x, float y, float r, float h, Object ltype, Color c, boolean isFill) {
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.ellipsePath(x, y, r, h);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.ellipsePath(x, y, r, h);
            this.strokePath();
        }
    }

    public void writeCircle(float x, float y, float r, Object ltype, Color c, boolean isFill) {
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.circlePath(x, y, r);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.circlePath(x, y, r);
            this.strokePath();
        }
    }

    public void writePolygon(Polygon p, Object ltype, Color c, boolean isFill) {
        this.setDefaultCoor();
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.polyPath(p);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.polyPath(p);
            this.closeAndStrokePath();
        }
    }

    public void writePolygon(RefList shape, Object ltype, Color c, boolean isFill) {
        this.setDefaultCoor();
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.reflistPath(shape);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.reflistPath(shape);
            this.closeAndStrokePath();
        }
    }

    public void writePolygon(float[] points, Object ltype, Color c, boolean isFill) {
        this.setDefaultCoor();
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            this.arrayPolyPath(points);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            this.arrayPolyPath(points);
            this.closeAndStrokePath();
        }
    }

    public void writePolyLine(RefList shape, Object ltype, Color c) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                this.setStrokeColor(c);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                this.setLStyle((LineStyle)ltype);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(c);
            this.setLStyle((LineStyle)ltype);
        }
        this.reflistPath(shape);
        this.strokePath();
    }

    public void writePolyLine(float[] point, Object ltype, Color c) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                this.setStrokeColor(c);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                this.setLStyle((LineStyle)ltype);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(c);
            this.setLStyle((LineStyle)ltype);
        }
        this.arrayPolyPath(point);
        this.strokePath();
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center) {
        this.writeText(str, x, y, fontName, fontSize, c, center, 0, 0.0f, 0.0f);
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style) {
        this.writeText(str, x, y, fontName, fontSize, c, center, style, 0.0f);
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style, float skew) {
        this.writeText(str, x, y, fontName, fontSize, c, center, style, skew, 0.0f);
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style, float skew, float rotate) {
        this.writeText(str, x, y, fontName, fontSize, c, center, style, skew, rotate, 0.0f, null);
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style, float skew, float rotate, float width, String type) {
        this.writeText(str, x, y, fontName, fontSize, c, center, style, skew, rotate, width, type, false);
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style, float skew, float rotate, float width, String type, boolean embed) {
        if (str == null || str.length() < 1) {
            return;
        }
        if (!embed || !this.embedFont(str, fontName)) {
            this.setFont(fontName, 0);
        }
        this.setFontSize(fontSize);
        this.saveState(1);
        this.writeUsingFont();
        if (style == 1 || style == 2) {
            this.setStrokeColor(c);
        }
        this.setFillColor(c);
        this.mTextMetrices = new PdfMetrices(1);
        if (this.mCurrentCharScaling != 100.0f) {
            this.writeCharScaling(100.0f);
        }
        if (this.mCurrentCharSpacing != 0.0f) {
            this.writeCharSpacing(0.0f);
        }
        float sx = x;
        float sy = y;
        float strWidth = this.mFont.getSize() * (float)this.mFont.stringWidth(str) / 1000.0f;
        float strHeight = this.mFont.getSize() / 3.0f;
        if (type != null && width > 0.0f) {
            if (type.equals("scaleX")) {
                this.writeCharScaling(width * 100.0f / strWidth);
            } else if (type.equals("spaceX")) {
                int len = str.length();
                if (len > 1) {
                    --len;
                }
                this.writeCharSpacing((width - strWidth) / (float)len);
            }
            if (center) {
                sx = x - strWidth;
                sy = y - strHeight;
            }
            strWidth = width / 2.0f;
        } else {
            strWidth /= 2.0f;
            if (center) {
                sx = x - strWidth;
                sy = y - strHeight;
            }
        }
        if (skew != 0.0f) {
            this.mTextMetrices.setSkew(0.0f, skew);
        }
        if (rotate != 0.0f) {
            if (center) {
                double rad = (double)(-rotate) * Math.PI / 180.0;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                sx = (float)((double)x - (double)strWidth * cos + sin * (double)strHeight);
                sy = (float)((double)y - (double)strWidth * sin - cos * (double)strHeight);
            }
            this.mTextMetrices.setRotation(rotate);
        }
        if (style != this.mCurrentFontStyle) {
            int textRenderingMode = 0;
            if (style == 2 || style == 1) {
                this.setLineWidth(fontSize * 0.03f);
                textRenderingMode = style;
            }
            this.mPrintStream.println(textRenderingMode + " Tr");
            this.mCurrentFontStyle = style;
        }
        this.drawText(str, sx, sy);
    }

    private void beginText() {
        this.resources.useText();
        this.mPrintStream.println("BT");
        this.isFontChanged = true;
    }

    private void endText() {
        this.mPrintStream.println("ET");
        this.mPrintStream.println();
        this.mCurrentFontStyle = 0;
        this.mCurrentCharScaling = 100.0f;
        this.mCurrentCharSpacing = 0.0f;
    }

    private void writeUsingFont() {
        if (this.getFont() == null) {
            this.setFont(this.bjf.DEFAULT_FONT);
        }
        if (this.isFontChanged) {
            this.mPrintStream.println(String.valueOf(this.mFont.getName().toString()) + " " + this.mFont.getSize() + " Tf");
            this.isFontChanged = false;
        }
    }

    private void writeCharSpacing(float spacing) {
        this.mPrintStream.println(this.mPdfUtil.formatPrint(spacing) + " Tc");
        this.mCurrentCharSpacing = spacing;
    }

    private void writeCharScaling(float scaling) {
        this.mPrintStream.println(this.mPdfUtil.formatPrint(scaling) + " Tz");
        this.mCurrentCharScaling = scaling;
    }

    private void drawText(String str, float x, float y) {
        byte[] byArray;
        byte[] b = null;
        try {
            if (this.mFont instanceof TrueTypeFont) {
                TrueTypeFont ttfTest = (TrueTypeFont)this.mFont;
                Hashtable cmap = ttfTest.getMTrueTypeFile().getCmaps();
                char[] gi = new char[str.length()];
                int j = 0;
                while (j < str.length()) {
                    gi[j] = (char)((Integer)cmap.get(new Integer(str.charAt(j)))).intValue();
                    ++j;
                }
                String tt = new String(gi, 0, str.length());
                b = tt.getBytes(this.mFont.getEncoding().getEncodingStr());
            } else {
                b = str.getBytes(this.mFont.getEncoding().getEncodingStr());
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            b = str.getBytes();
        }
        if (b == null) {
            return;
        }
        this.mTextMetrices.setTranslation(x, y);
        this.mPrintStream.print(this.mTextMetrices.toString());
        if (this.mFont instanceof TrueTypeFont) {
            this.mPrintStream.print("(");
            byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                if (element > 0) {
                    this.mPrintStream.print(this.toOctalString(element));
                } else {
                    this.mPrintStream.write(element);
                }
                ++n2;
            }
            this.mPrintStream.println(") Tj");
        } else {
            this.mPrintStream.print("<");
            byArray = b;
            int n = b.length;
            int n3 = 0;
            while (n3 < n) {
                byte element = byArray[n3];
                this.mPrintStream.print(Integer.toHexString(0xFF & element));
                ++n3;
            }
            this.mPrintStream.println("> Tj");
        }
    }

    private String toOctalString(int n) {
        String s = Integer.toOctalString(n);
        return String.valueOf("\\000".substring(0, 4 - s.length())) + s;
    }

    private boolean embedFont(String str, String fontName) {
        TrueTypeFont ttf;
        Object o = this.mUsingEmbededFonts.get(fontName);
        if (o == null) {
            File fontFile = FontFactory.getFontFile(fontName);
            if (fontFile == null) {
                return false;
            }
            String filePath = fontFile.getAbsolutePath();
            ttf = new TrueTypeFont(filePath);
            ttf.setListFontName("TTF" + this.mBody.size());
            if (ttf.isTrueTypeCollection()) {
                ttf.getMTrueTypeFile().checkTTC(fontName);
            }
            ttf.loadFontDirectory();
            Object fo = this.mBody.getFontCollection().get(ttf.getBaseFont());
            if (fo == null) {
                this.mUsingEmbededFonts.put(fontName, ttf);
            } else {
                try {
                    ttf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ttf = (TrueTypeFont)fo;
            }
        } else {
            ttf = (TrueTypeFont)o;
        }
        ttf.resetUesedChars(str);
        ttf.createFont();
        this.setFont(ttf);
        return true;
    }

    public void writeImage(ImageXObject img, float x, float y, float width, float height, float ang) {
        img.getMTransMatrices().setRotation(ang);
        this.imageDrawer(img, x, y, width, height);
    }

    public void writeImage(Image img, float x, float y, float width, float height, float ang) {
        ImageXObject imgX = new ImageXObject(img);
        this.writeImage(imgX, x, y, width, height, ang);
    }

    public void writeImage(int[] pixels, int imgW, int imgH, float x, float y, float width, float height, float ang) {
        ImageXObject imgX = new ImageXObject(pixels, imgW, imgH);
        this.writeImage(imgX, x, y, width, height, ang);
    }

    public void writeJpegImage(byte[] jpgdata, int imgW, int imgH, float x, float y, float width, float height, float ang) {
        ImageXObjectJpeg imgX = new ImageXObjectJpeg(jpgdata, imgW, imgH);
        this.writeImage(imgX, x, y, width, height, ang);
    }

    public void writeForm(FormXObject form, float x, float y, float width, float height) {
        this.drawForm(form, x, y, width, height);
    }

    public void writeForm(FormXObject form, float x, float y, float width, float height, float ang) {
        form.getMTransMatrices().setRotation(ang);
        this.drawForm(form, x, y, width, height);
    }

    public void writeForm(FormXObject form, float x, float y, float width, float height, float ang, float border, Object lStyle, Color borderColor) {
        form.writeBorder(border, (LineStyle)lStyle, borderColor);
        form.getMTransMatrices().setRotation(ang);
        this.drawForm(form, x, y, width, height);
    }

    public void writeLink(String url, PdfRect rect) {
        rect.setLux(rect.getLux() * 2.8346f);
        rect.setLuy(rect.getLuy() * 2.8346f);
        rect.setRdx(rect.getRdx() * 2.8346f);
        rect.setRdy(rect.getRdy() * 2.8346f);
        PdfAnnotation annot = new PdfAnnotation(this.mBody).createURILink(this.mBody, url, rect);
        this.mBody.add(annot);
        this.mBody.getCurrentPage().getAnnotArray().addElement(annot.getReference());
    }

    public void writeLink(String url, PdfRect rect, float border) {
        rect.setLux(rect.getLux() * 2.8346f);
        rect.setLuy(rect.getLuy() * 2.8346f);
        rect.setRdx(rect.getRdx() * 2.8346f);
        rect.setRdy(rect.getRdy() * 2.8346f);
        PdfAnnotation annot = new PdfAnnotation(this.mBody).createLink(this.mBody, url, rect, border);
        this.mBody.add(annot);
        this.mBody.getCurrentPage().getAnnotArray().addElement(annot.getReference());
    }

    public void write3D(byte[] u3d, PdfRect rect, float border, Color background, float fov, float co) {
        rect.setLux(rect.getLux() * 2.8346f);
        rect.setLuy(rect.getLuy() * 2.8346f);
        rect.setRdx(rect.getRdx() * 2.8346f);
        rect.setRdy(rect.getRdy() * 2.8346f);
        FormXObject form = new FormXObject(this.mBody, new PdfRect(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        form.setFlagCompress(true);
        this.mBody.add(form);
        EmbedU3DFile u3dFile = new EmbedU3DFile();
        u3dFile.setU3DData(u3d);
        this.mBody.add(u3dFile);
        PdfAnnotation annot = new PdfAnnotation(this.mBody).create3D(this.mBody, u3dFile, rect, form, border, background, fov, co);
        this.mBody.add(annot);
        this.mBody.getCurrentPage().getAnnotArray().addElement(annot.getReference());
    }

    public void flush() {
        try {
            this.stream.flush();
            this.mPrintStream.flush();
            this.streamOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.stream.close();
            this.mPrintStream.close();
            this.streamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerPattern(String name) {
        Pattern p = this.getPattern(name);
        if (p == null) {
            throw new IllegalArgumentException("unknown pattern [" + name + "]");
        }
        this.addPattern(p);
    }

    public Pattern getPattern(String name) {
        if (TilingPattern.PATTERN_STAR.equals(name)) {
            return this.getStarPattern();
        }
        return null;
    }

    public Pattern getStarPattern() {
        return TilingPattern.getStarPattern(this.mBody);
    }

    public void addPattern(Pattern p) {
        this.resources.addPattern(p);
    }

    public void registerShading(String name) {
        Shading s = this.getShading(name);
        if (s == null) {
            throw new IllegalArgumentException("unknown shading [" + name + "]");
        }
        this.addShading(s);
    }

    public Shading getShading(String name) {
        if (ShadingType2.isType2(name)) {
            return ShadingType2.getDefaultShadingType2(this.mBody, name);
        }
        return null;
    }

    public void addShading(Shading s) {
        this.resources.addShading(s);
    }

    private void startPattern(String name, Color c) {
        this.mPrintStream.println("/Pattern cs");
        this.mPrintStream.println("/" + name + " scn");
        this.setStrokeColor(c);
        this.mPrintStream.println(new LineStyle(0.5f));
    }

    private void endPattern() {
        this.mPrintStream.println("B*");
    }

    public void clipPath() {
        this.mPrintStream.println("W* n");
    }

    public void shading(String name) {
        this.mPrintStream.println("/" + name + " sh");
    }

    public void writeGroupPolygon(float[][] points, Object ltype, Color c, boolean isFill) {
        this.setDefaultCoor();
        if (isFill) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(c)) {
                    this.setFillColor(c);
                }
            } else {
                this.saveState(4);
                this.setFillColor(c);
            }
            float[][] fArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                float[] point = fArray[n2];
                this.arrayPolyPath(point);
                this.closePath();
                ++n2;
            }
            this.fillPathUsingOddEvenRule();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(c)) {
                    this.setStrokeColor(c);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(ltype)) {
                    this.setLStyle((LineStyle)ltype);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(c);
                this.setLStyle((LineStyle)ltype);
            }
            float[][] fArray = points;
            int n = points.length;
            int n3 = 0;
            while (n3 < n) {
                float[] point = fArray[n3];
                this.arrayPolyPath(point);
                this.closePath();
                ++n3;
            }
            this.strokePath();
        }
    }

    public void writePatternedPolygon(float[] points, String name) {
        this.writePatternedGroupPolygon(new float[][]{points}, name);
    }

    public void writePatternedGroupPolygon(float[][] points, String name) {
        LineStyle l = new LineStyle();
        l.setLineWidth(0.1f);
        this.writeGroupPolygon(points, l, Color.white, true);
        this.registerPattern(name);
        this.setDefaultCoor();
        this.loadState();
        this.saveState(4);
        this.startPattern(name, Color.black);
        float[][] fArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            float[] point = fArray[n2];
            this.arrayPolyPath(point);
            this.closePath();
            ++n2;
        }
        this.endPattern();
        this.loadState();
    }

    public void writeShadingPolygon(float[] points, String name) {
        this.writeShadingGroupPolygon(new float[][]{points}, name);
    }

    public void writeShadingGroupPolygon(float[][] points, String name) {
        this.setDefaultCoor();
        this.registerShading(name);
        this.saveState(4);
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float[][] fArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            float[] point = fArray[n2];
            this.arrayPolyPath(point);
            this.closePath();
            int j = 0;
            while (j < point.length) {
                float x = point[j];
                float y = point[j + 1];
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                j += 2;
            }
            ++n2;
        }
        this.clipPath();
        this.writeCurrentTransformationMatrix(maxX - minX, 0.0f, 0.0f, maxY - minY, minX, minY);
        this.shading(name);
        this.loadState();
    }

    public void setClip(float x, float y, float width, float height) {
        this.releaseClip();
        this.mClipRect = new PdfRect(x, y, x + width, y + height);
    }

    private void clipRect() {
        if (this.mClipRect != null) {
            this.beginPath(this.mClipRect.getLux(), this.mClipRect.getLuy());
            this.linePath(this.mClipRect.getRdx(), this.mClipRect.getLuy());
            this.linePath(this.mClipRect.getRdx(), this.mClipRect.getRdy());
            this.linePath(this.mClipRect.getLux(), this.mClipRect.getRdy());
            this.clipPath();
        }
    }

    public void releaseClip() {
        this.loadState();
        this.mClipRect = null;
    }

    class TextObject {
        public static final int PLAIN = 0;
        public static final int BORDER = 1;
        public static final int BOLD = 2;
        String str;
        float skew;
        int style = 0;
        Color strokeC;
        Color fillC;
        float mRotate;
    }
}

