/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import d.d;
import java.util.Vector;
import option.io.pdfcommon.command.PdfFormatReader;
import option.io.pdfcommon.path.Format;

public class PdfFormatFactory {
    private static final String DEFAULT_ENCODING = "MS932";
    private Vector<Format> mFormats = new Vector();
    private static PdfFormatFactory mInstance;

    private PdfFormatFactory() {
    }

    public static PdfFormatFactory getInstance() {
        if (mInstance == null) {
            mInstance = new PdfFormatFactory();
        }
        return mInstance;
    }

    public void dispose() {
        this.mFormats.removeAllElements();
        this.mFormats = null;
        mInstance = null;
    }

    public synchronized Format getOrCreateFormat(String formatName) {
        return this.getOrCreateFormat(formatName, DEFAULT_ENCODING);
    }

    public synchronized Format getOrCreateFormat(String formatName, String encoding) {
        int i = 0;
        while (i < this.mFormats.size()) {
            Format format = this.mFormats.elementAt(i);
            if (format.getAbsolutePath().equals(formatName)) {
                return format;
            }
            ++i;
        }
        Format format = this.createFormat(formatName, encoding);
        if (format != null) {
            this.mFormats.addElement(format);
        }
        return format;
    }

    public synchronized Format getFormat(String formatName) {
        int i = 0;
        while (i < this.mFormats.size()) {
            Format format = this.mFormats.elementAt(i);
            if (format.getAbsolutePath().equals(formatName)) {
                return format;
            }
            ++i;
        }
        return null;
    }

    private Format createFormat(String formatName, String encoding) {
        PdfFormatReader reader;
        if (d.d) {
            System.out.println("PDF Format created [" + formatName + "]");
        }
        if ((reader = new PdfFormatReader(formatName, encoding)).canRead()) {
            return reader.getFormat();
        }
        return null;
    }
}

