/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import java.util.StringTokenizer;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.function.Function;
import option.io.pdfcommon.function.FunctionType2;
import option.io.pdfcommon.function.FunctionType3;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;

public class ShadingType2
extends Shading
implements Pattern {
    public static String SHADING_TYPE_2 = "TYPE2_";
    private float[] mDomain;
    private float[] mCoords;
    private boolean[] mExtend;
    private Function mFunc;

    public ShadingType2(Body body, String name) {
        this(body, 2, name);
    }

    protected ShadingType2(Body body, int type, String name) {
        super(body, type, name);
    }

    public static boolean isType2(String str) {
        return str != null && str.indexOf(SHADING_TYPE_2) == 0;
    }

    public void setDomain(float[] domain) {
        this.mDomain = domain;
    }

    public void setCoords(float[] coords) {
        this.mCoords = coords;
    }

    public void setExtend(boolean[] extend) {
        this.mExtend = extend;
    }

    public void setFunction(Function f) {
        this.mFunc = f;
    }

    @Override
    public void updateDict() {
        super.updateDict();
        String s = this.toArrayString(this.mDomain, true);
        if (s != null) {
            this.dict.put(DOMAIN, s);
        }
        if ((s = this.toArrayString(this.mCoords, true)) != null) {
            this.dict.put(COORDS, s);
        }
        if ((s = this.toArrayString(this.mExtend, true)) != null) {
            this.dict.put(EXTEND, s);
        }
        if (this.mFunc != null) {
            this.dict.put(FUNCTION, this.mFunc.getReference());
        }
    }

    public static Shading getDefaultShadingType2_(Body body, String name) {
        return ShadingType2.getDefaultShadingType2(body, name);
    }

    public static Shading getDefaultShadingType2(Body body, String name) {
        Pattern p = body.search(name);
        if (p != null && p instanceof Shading) {
            return (Shading)((Object)p);
        }
        StringTokenizer st = new StringTokenizer(name, "_");
        String rgb = null;
        String axis = null;
        String cycle = null;
        if (st.hasMoreElements()) {
            st.nextToken();
        }
        if (st.hasMoreElements()) {
            rgb = st.nextToken();
        }
        if (st.hasMoreElements()) {
            axis = st.nextToken();
        }
        if (st.hasMoreElements()) {
            cycle = st.nextToken();
        }
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        float r2 = 0.0f;
        float g2 = 0.0f;
        float b2 = 0.0f;
        try {
            r1 = Float.parseFloat(rgb.substring(0, 3)) / 255.0f;
            g1 = Float.parseFloat(rgb.substring(3, 6)) / 255.0f;
            b1 = Float.parseFloat(rgb.substring(6, 9)) / 255.0f;
            r2 = Float.parseFloat(rgb.substring(9, 12)) / 255.0f;
            g2 = Float.parseFloat(rgb.substring(12, 15)) / 255.0f;
            b2 = Float.parseFloat(rgb.substring(15, 18)) / 255.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 1.0f;
        float y2 = 0.0f;
        if (axis != null) {
            StringTokenizer st2 = new StringTokenizer(axis, ":");
            if (st2.hasMoreElements()) {
                x1 = Float.valueOf(st2.nextToken()).floatValue();
            }
            if (st2.hasMoreElements()) {
                y1 = Float.valueOf(st2.nextToken()).floatValue();
            }
            if (st2.hasMoreElements()) {
                x2 = Float.valueOf(st2.nextToken()).floatValue();
            }
            if (st2.hasMoreElements()) {
                y2 = Float.valueOf(st2.nextToken()).floatValue();
            }
        }
        boolean cyclic = false;
        if (cycle != null) {
            cyclic = Integer.parseInt(cycle) > 0;
        }
        ShadingType2 sh = null;
        if (!cyclic) {
            float[] domain = new float[]{0.0f, 1.0f};
            sh = new ShadingType2(body, name);
            FunctionType2 f22 = new FunctionType2(body);
            f22.setDomain(domain);
            f22.setC0(new float[]{r1, g1, b1});
            f22.setC1(new float[]{r2, g2, b2});
            f22.setN(1.0f);
            sh.setFunction(f22);
        } else {
            float[] domain = new float[]{0.0f, 1.0f};
            sh = new ShadingType2(body, name);
            FunctionType3 func = new FunctionType3(body);
            func.setDomain(domain);
            func.setBounds(new float[]{0.5f});
            func.setEncode(new float[]{1.0f, 0.0f, 1.0f, 0.0f});
            FunctionType2 f22 = new FunctionType2(body);
            f22.setDomain(domain);
            f22.setC0(new float[]{r2, g2, b2});
            f22.setC1(new float[]{r1, g1, b1});
            f22.setN(1.0f);
            func.addFunction(f22);
            FunctionType2 f21 = new FunctionType2(body);
            f21.setDomain(domain);
            f21.setC0(new float[]{r1, g1, b1});
            f21.setC1(new float[]{r2, g2, b2});
            f21.setN(1.0f);
            func.addFunction(f21);
            sh.setFunction(func);
        }
        sh.setCoords(new float[]{x1, y1, x2, y2});
        sh.setExtend(new boolean[]{true, true});
        sh.setColorSpace(DefinedName.DEVICERGB);
        return sh;
    }
}

