/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFile;
import option.io.pdfcommon.font.TrueTypeFontFileReader;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class TrueTypeFont
extends PdfFont {
    private static final String BASE_FONT_PREFIX = "TTF+";
    boolean isEmbed;
    public String fontFileName;
    TrueTypeFile mTrueTypeFile;
    TrueTypeFontFileReader fr;
    CIDFont cf;
    CIDSystemInfo cfInfo;
    FontDescriptor cfd;
    int[] fontbox = new int[4];
    String listFontName;
    PdfName baseFontName;
    private boolean mIsLoaded;

    public TrueTypeFont() {
        this.setEncoding(new Encoding("UnicodeBigUnmarked"));
        this.cmapStream = new CmapStream();
        this.embedFontFile = new EmbedFontFile();
    }

    public TrueTypeFont(String fn) {
        this();
        this.fontFileName = fn;
        try {
            this.fr = new TrueTypeFontFileReader(this.fontFileName, "r");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.mTrueTypeFile = new TrueTypeFile();
        this.mTrueTypeFile.fr = this.fr;
        this.cf = new CIDFont();
        this.cfInfo = new CIDSystemInfo();
        this.cfd = new FontDescriptor();
    }

    public void resetUesedChars(String used) {
        this.mTrueTypeFile.resetUsedChars(used);
    }

    private void setBaseFontName(String fontName) {
        this.baseFontName = new PdfName(BASE_FONT_PREFIX + fontName);
        this.setBaseFont(this.baseFontName);
    }

    public void loadFontDirectory() {
        this.mTrueTypeFile.loadFontDirectory();
        this.setBaseFontName(this.mTrueTypeFile.getFontName());
    }

    public void createFont() {
        if (!this.mIsLoaded) {
            this.mTrueTypeFile.LoadFontData();
            this.mIsLoaded = true;
        }
        this.mTrueTypeFile.getUsedGlyphIndexs();
        this.cmapStream.setCmapStr(this.mTrueTypeFile.getUsedCmaps());
        this.embedFontFile.setFontData(this.mTrueTypeFile.getFontData());
        this.setBaseFontName(this.mTrueTypeFile.getFontName());
        this.fontbox = this.mTrueTypeFile.getFontBox();
        this.setSubtype(DefinedName.TYPE0);
        this.setName(new PdfName(this.listFontName));
        this.setDescendantFont(this.cf);
        this.setEncoding(this.getEncoding());
        this.cf.setSubtype(DefinedName.CIDFONTTYPE2);
        this.cf.setName(this.getName());
        this.cf.setBaseFont(this.baseFontName);
        this.cf.setFontDescriptor(this.cfd);
        this.cf.setCIDSystemInfo(this.getEncoding().getMCIDSystemInfo());
        this.cf.setDW(1000);
        this.cf.dict.put(CIDTOGIDMAP, new PdfName("Identity"));
        PdfArray w = new PdfArray();
        int[] gi = this.mTrueTypeFile.getUsedGIInt();
        int[] ws = this.mTrueTypeFile.getUsedGWidths();
        for (int i = 0; i < gi.length; ++i) {
            if (ws[i] == 1000) continue;
            w.addElement(gi[i] + " [" + ws[i] + "]");
        }
        this.cf.setW(w);
        this.cfd.setFontName(this.baseFontName);
        this.cfd.setAscent(this.mTrueTypeFile.getAscent());
        this.cfd.setCapHeight(this.mTrueTypeFile.getCapHeight());
        this.cfd.setDescent(this.mTrueTypeFile.getDscent());
        this.cfd.setFlags(this.mTrueTypeFile.getFlags());
        this.cfd.setFontBBox(new PdfRect(this.fontbox[0], this.fontbox[1], this.fontbox[2], this.fontbox[3]));
        this.cfd.setItalicAngle((int)this.mTrueTypeFile.getItalicAngle());
        this.cfd.setStemV(this.mTrueTypeFile.getStemV());
        this.cfd.setMEmbedFontFile(this.embedFontFile);
    }

    public TrueTypeFile getMTrueTypeFile() {
        return this.mTrueTypeFile;
    }

    public void setListFontName(String name) {
        this.listFontName = name;
    }

    public String getListFontName() {
        return this.listFontName;
    }

    @Override
    public int charWidth(char ch) {
        Integer gi = (Integer)this.mTrueTypeFile.getCmaps().get(new Integer(ch));
        return (Integer)this.mTrueTypeFile.getUsedGI_GW().get(gi);
    }

    public boolean isTrueTypeCollection() {
        return this.fontFileName.toLowerCase().indexOf(".ttc") > 0;
    }

    public void close() throws IOException {
        if (this.fr != null) {
            this.fr.close();
        }
    }
}

