/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.File;
import java.util.Vector;

public class FontFactory {
    private static String[][] FONTDATA;
    private static Vector mExtensions;
    private static String mFontDir;

    public static void setUseFonts(String[][] str) {
        FONTDATA = str;
    }

    public static void addExtension(String extension) {
        mExtensions.addElement(extension);
    }

    public static void removeExtension(String extension) {
        int count = FontFactory.getExtensionCount();
        for (int i = 0; i < count; ++i) {
            if (!extension.equals(FontFactory.getExtension(i))) continue;
            mExtensions.removeElementAt(i);
            break;
        }
    }

    public static int getExtensionCount() {
        return mExtensions.size();
    }

    public static String getExtension(int index) {
        return (String)mExtensions.elementAt(index);
    }

    public static void setFontDirectory(String dir) {
        mFontDir = dir;
    }

    public static String getFontDirectory() {
        return mFontDir;
    }

    public static File getFontFile(String fontName) {
        int count = FontFactory.getExtensionCount();
        String fontfilename = "";
        if (FONTDATA != null) {
            for (String[] data : FONTDATA) {
                if (!data[0].equalsIgnoreCase(fontName)) continue;
                fontfilename = data[1];
                break;
            }
        }
        if (fontfilename == null || fontfilename.length() == 0) {
            fontfilename = "msgothic";
        }
        for (int i = 0; i < count; ++i) {
            File f = new File(mFontDir + "\\" + fontfilename + "." + FontFactory.getExtension(i));
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static boolean isProportionalFont(String fontName) {
        boolean isprop = false;
        if (FONTDATA != null) {
            for (String[] data : FONTDATA) {
                if (!data[0].equalsIgnoreCase(fontName)) continue;
                if (data[2] == null || !data[2].equalsIgnoreCase("1")) break;
                isprop = true;
                break;
            }
        }
        return isprop;
    }

    static {
        mExtensions = new Vector(2);
    }
}

