/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.util.PdfRect;

public class PageSize
implements PdfDataConst {
    private int mDpi = 72;
    private float mRate = (float)this.mDpi * 1.0f / 25.4f;

    public PageSize() {
    }

    public PageSize(int dpi) {
        this.setDpi(dpi);
    }

    public int getDpi() {
        return this.mDpi;
    }

    public void setDpi(int dpi) {
        this.mDpi = dpi;
        this.mRate = (float)this.mDpi / 25.4f;
    }

    public float getRate() {
        return this.mRate;
    }

    public PdfRect getPageRect(String ps) {
        float[] wh = PageSize.getMideaWH(ps);
        if (wh == null) {
            return null;
        }
        return new PdfRect(0.0f, 0.0f, wh[0] * this.getRate(), wh[1] * this.getRate());
    }

    public PdfRect getPageRect(String ps, int dir) {
        PdfRect re = this.getPageRect(ps);
        if (dir == 1) {
            re.changeDirection();
        }
        return re;
    }

    public static PdfRect getPagemm(String ps) {
        float[] wh = PageSize.getMideaWH(ps);
        if (wh == null) {
            return null;
        }
        return new PdfRect(0.0f, 0.0f, wh[0], wh[1]);
    }

    public static PdfRect getPagemm(String ps, int dir) {
        PdfRect re = PageSize.getPagemm(ps);
        if (dir > 0) {
            re.changeDirection();
        }
        return re;
    }

    private static float[] getMideaWH(String mediaSize) {
        int index = PageSize.indexOfMediaSize(mediaSize);
        if (index < 0) {
            return null;
        }
        return MEDIA_SIZE[index];
    }

    private static int indexOfMediaSize(String mediaSize) {
        int media_size_len = 2;
        if (mediaSize == null) {
            return -1;
        }
        if ((mediaSize = mediaSize.trim().toUpperCase()).length() != 2) {
            return -1;
        }
        return "A1A2A3A4A5A6A6A7A9A10B1B2B3B4B5B6B7B8B9B10".indexOf(mediaSize) / 2;
    }
}

