/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Component;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import option.io.pdfcommon.command.PdfCommandImage;
import option.io.pdfcommon.command.PdfDrawCommandParser;
import option.io.pdfcommon.path.FormatAttribute;
import option.io.pdfcommon.path.ItemImageAttribute;
import option.io.pdfcommon.path.ItemTextAttribute;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathText;

public class PdfFormatParser
extends PdfDrawCommandParser {
    protected Component mComponent;

    public PdfFormatParser(String base, Component comp) {
        super(base);
        this.mComponent = comp;
    }

    @Override
    public Path parseDrawCommand(String command) {
        StringTokenizer st = new StringTokenizer(command, ", ");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String cmd = st.nextToken().trim();
        if (cmd.equals("date")) {
            return this.createDate(command);
        }
        if (cmd.equals("itemtext")) {
            return this.createItemTextAttribute(command);
        }
        if (cmd.equals("itemimage")) {
            return this.createItemImageAttribute(command);
        }
        if (cmd.equals("pagesize")) {
            return this.createPageAttribute(command);
        }
        return super.parseDrawCommand(command);
    }

    protected Path createPageAttribute(String s) {
        StringTokenizer st = new StringTokenizer(s);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return null;
        }
        String size = st.nextToken();
        int dir = 0;
        int dpi = 72;
        if (st.hasMoreElements()) {
            dir = Integer.valueOf(st.nextToken());
        }
        if (st.hasMoreElements()) {
            dpi = Integer.valueOf(st.nextToken());
        }
        return new FormatAttribute(size, dir, dpi);
    }

    protected PathText createDate(String s) {
        StringTokenizer st = new StringTokenizer(s, "#");
        st.nextToken();
        String text = st.nextToken().trim();
        String line = st.nextToken().trim();
        return this.createText(new String("text#" + this.formatDate(text) + "#" + line));
    }

    protected ItemTextAttribute createItemTextAttribute(String s) {
        PathText text = this.createText(s);
        if (text != null) {
            return new ItemTextAttribute(text);
        }
        return null;
    }

    protected ItemImageAttribute createItemImageAttribute(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count == 6) {
            st.nextToken();
            String name = st.nextToken();
            float x1 = Float.valueOf(st.nextToken()).floatValue();
            float y1 = Float.valueOf(st.nextToken()).floatValue();
            float x2 = Float.valueOf(st.nextToken()).floatValue();
            float y2 = Float.valueOf(st.nextToken()).floatValue();
            float width = Math.abs(x2 - x1);
            float height = Math.abs(y2 - y1);
            return new ItemImageAttribute(name, new PathImage(null, width, height, x1, y1, width, height, 0.0f));
        }
        return null;
    }

    private String formatDate(String date) {
        int m;
        GregorianCalendar cal = new GregorianCalendar();
        String tmp = String.valueOf(cal.get(1));
        if ((date = date.indexOf("yyyy") >= 0 ? date.replaceFirst("yyyy", tmp) : date.replaceFirst("yy", tmp.substring(2, 4))).indexOf("ww") >= 0) {
            int w = Integer.valueOf(tmp) - 1988;
            date = date.replaceFirst("ww", String.valueOf(w));
        }
        tmp = (m = cal.get(2) + 1) < 10 ? new String("0" + m) : String.valueOf(m);
        date = date.replaceFirst("mm", tmp);
        int d2 = cal.get(5);
        tmp = d2 < 10 ? new String("0" + d2) : String.valueOf(d2);
        return date.replaceFirst("dd", tmp);
    }

    @Override
    protected PathImage createImage(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int count = st.countTokens();
        if (count != 9) {
            return null;
        }
        st.nextToken();
        int[] image = null;
        Object obj = this.getImage(st.nextToken());
        if (obj != null) {
            image = ((PdfCommandImage)obj).getPixels();
        }
        if (image == null) {
            return null;
        }
        float imgW = Float.valueOf(st.nextToken()).floatValue();
        float imgH = Float.valueOf(st.nextToken()).floatValue();
        float x1 = Float.valueOf(st.nextToken()).floatValue();
        float y1 = Float.valueOf(st.nextToken()).floatValue();
        float x2 = Float.valueOf(st.nextToken()).floatValue();
        float y2 = Float.valueOf(st.nextToken()).floatValue();
        float angle = Float.valueOf(st.nextToken()).floatValue();
        return new PathImage(image, imgW, imgH, x1 < x2 ? x1 : x2, y1 < y2 ? y1 : y2, Math.abs(x2 - x1), Math.abs(y2 - y1), angle);
    }

    protected Object getImage(String file) {
        if (file == null) {
            return null;
        }
        return new PdfCommandImage(this.getAbsoluteFilePath(file), this.mComponent);
    }

    protected String getAbsoluteFilePath(String file) {
        return this.mBase + File.separator + file;
    }
}

