/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class Shading
extends DictObj {
    private int mShadingType;
    private PdfName mColorSpace;
    private PdfRect mBBox;
    private boolean mAntiAlias;
    private PdfName mName;

    public Shading(Body body, int type, String name) {
        super(body);
        body.add(this);
        this.setShadingType(type);
        this.setName(name);
    }

    public void setShadingType(int type) {
        this.mShadingType = type;
    }

    public void setColorSpace(PdfName colorSpace) {
        this.mColorSpace = colorSpace;
    }

    public void setBBox(PdfRect bbox) {
        this.mBBox = bbox;
    }

    public void setName(String name) {
        this.mName = new PdfName(name);
    }

    public PdfName getName() {
        return this.mName;
    }

    @Override
    public void updateDict() {
        this.dict.clear();
        this.dict.put(SHADINGTYPE, this.mShadingType);
        if (this.mColorSpace != null) {
            this.dict.put(COLORSPACE, this.mColorSpace);
        }
        if (this.mBBox != null) {
            this.dict.put(BBOX, this.mBBox);
        }
        if (this.mAntiAlias) {
            this.dict.put(ANTIALIAS, Boolean.TRUE);
        }
    }

    protected String toArrayString(float[] array, boolean bracket) {
        if (array == null || array.length < 1) {
            return null;
        }
        if (array.length == 1 && !bracket) {
            return String.valueOf(array[0]);
        }
        StringBuffer sb = new StringBuffer("[");
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(" ");
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    protected String toArrayString(boolean[] array, boolean bracket) {
        if (array == null || array.length < 1) {
            return null;
        }
        if (array.length == 1 && !bracket) {
            return String.valueOf(array[0]);
        }
        StringBuffer sb = new StringBuffer("[");
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(" ");
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

