/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.awt.Color;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;

public class PathPolygon
implements Path {
    protected float[] mPoints;
    protected LineStyle mLineStyle;
    protected Color mColor;
    protected boolean mFill;
    protected String mPattern;
    protected boolean mIsShading;

    public PathPolygon(float[] points, LineStyle style, Color color, boolean fill) {
        this.mPoints = points;
        this.mLineStyle = style;
        this.mColor = color;
        this.mFill = fill;
    }

    @Override
    public boolean draw(Contents con) {
        if (this.mPattern == null) {
            con.writePolygon(this.mPoints, (Object)this.mLineStyle, this.mColor, this.mFill);
        } else if (this.mIsShading) {
            con.writeShadingPolygon(this.mPoints, this.mPattern);
        } else {
            con.writePatternedPolygon(this.mPoints, this.mPattern);
        }
        return true;
    }

    @Override
    public void setPattern(String name) {
        this.mPattern = name;
        this.mIsShading = false;
    }

    @Override
    public void setShading(String name) {
        this.mPattern = name;
        this.mIsShading = true;
    }
}

