/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class BaseJapanNoEmbedFont
implements DefinedName {
    private Vector baseFontNames = new Vector();
    private Hashtable definedFonts = new Hashtable();
    private Encoding mEncoding = new Encoding("MS932");
    private int style = 0;
    public PdfFont DEFAULT_FONT = this.makePdfFont("MS Gothic", this.baseFontNames.size() - 1, this.style);

    public BaseJapanNoEmbedFont() {
        for (int i = 0; i < this.baseFontNames.size(); ++i) {
            String fn = (String)this.baseFontNames.elementAt(i);
            PdfFont pft = this.makePdfFont(fn, i, this.style);
            this.definedFonts.put(fn, pft);
        }
    }

    public PdfFont getDefinedFont(String fn) {
        Object o = this.definedFonts.get(fn);
        if (o != null && o instanceof PdfFont) {
            return (PdfFont)o;
        }
        return null;
    }

    public PdfFont getBaseFont(String fn) {
        Font tf = new Font(fn, this.style, 1000);
        PdfFont pf = this.getDefinedFont(tf.getFamily());
        if (pf == null) {
            pf = this.makePdfFont(tf.getFamily(), this.baseFontNames.size(), this.style);
            this.definedFonts.put(tf.getFamily(), pf);
            this.baseFontNames.add(tf.getFamily());
        }
        if (pf == null) {
            pf = this.DEFAULT_FONT;
        }
        return pf;
    }

    private PdfFont makePdfFont(String fn, int index, int style) {
        Font tf = new Font(fn, style, 1000);
        LineMetrics lm = tf.getLineMetrics("\u65e5\u672c\u8a9e", new FontRenderContext(new AffineTransform(), false, false));
        PdfFont pf = new PdfFont();
        CIDFont cf = new CIDFont();
        FontDescriptor cfd = new FontDescriptor();
        PdfName baseFontName = new PdfName(tf.getFamily().replaceAll(" ", ""));
        pf.setSubtype(TYPE0);
        pf.setName(new PdfName("JF" + index));
        pf.setBaseFont(baseFontName);
        pf.setDescendantFont(cf);
        pf.setFontDescriptor(cfd);
        pf.setEncoding(this.mEncoding);
        pf.setFontDescriptor(cfd);
        cf.setSubtype(CIDFONTTYPE2);
        cf.setName(pf.getName());
        cf.setBaseFont(baseFontName);
        cf.setFontDescriptor(cfd);
        cf.setCIDSystemInfo(new CIDSystemInfo());
        cf.setDW(1000);
        PdfArray w = new PdfArray();
        w.addElement("231 389 600");
        cf.setW(w);
        cfd.setFontName(baseFontName);
        cfd.setAscent((int)lm.getAscent());
        cfd.setCapHeight((int)(lm.getAscent() + lm.getLeading()));
        cfd.setDescent((int)(-lm.getDescent()));
        cfd.setFlags(0);
        cfd.setFontBBox(new PdfRect(0.0f, 0.0f, 0.0f, 0.0f));
        return pf;
    }
}

