/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Resources;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.util.PdfRect;

public class TilingPattern
extends Contents
implements Pattern {
    public static String PATTERN_STAR = "Pt101d";
    private PdfName mName;

    public TilingPattern(Body body, PdfRect mediabox, String name) {
        this.mBody = body;
        this.mediabox = mediabox;
        this.stream = new PdfStream();
        this.mPrintStream = this.stream.getPrintStream();
        this.resources = new Resources(body);
        body.add(this);
        body.add(this.resources);
        this.dict.put(TYPE, PATTERN);
        this.dict.put(PATTERNTYPE, new Integer(1));
        this.dict.put(PAINTTYPE, new Integer(1));
        this.dict.put(TILINGTYPE, new Integer(1));
        this.dict.put(BBOX, mediabox);
        this.dict.put(RESOURCES, this.resources.getReference());
        this.setName(name);
    }

    public void setXStep(int xStep) {
        this.dict.put(XSTEP, new Integer(xStep));
    }

    public void setYStep(int yStep) {
        this.dict.put(YSTEP, new Integer(yStep));
    }

    public void setName(String name) {
        this.mName = new PdfName(name);
    }

    @Override
    public PdfName getName() {
        return this.mName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)obj;
        return this.getName().equals(pattern.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static Pattern getStarPattern(Body body) {
        Pattern pt = body.search(PATTERN_STAR);
        if (pt != null) {
            return pt;
        }
        TilingPattern p = new TilingPattern(body, new PdfRect(0.0f, 0.0f, 60.0f, 60.0f), PATTERN_STAR);
        p.setXStep(60);
        p.setYStep(60);
        float[] s0 = new float[]{15.0f, 27.0f, 7.947f, 5.292f, 26.413f, 18.708f, 3.587f, 18.708f, 22.053f, 5.292f, 15.0f, 27.0f};
        float[] s1 = new float[]{45.0f, 57.0f, 37.947f, 35.292f, 56.413f, 48.708f, 33.587f, 48.708f, 52.053f, 35.292f, 45.0f, 57.0f};
        float[] s2 = new float[]{15.0f, 57.0f, 7.947f, 35.292f, 26.413f, 48.708f, 3.587f, 48.708f, 22.053f, 35.292f, 15.0f, 57.0f};
        float[] s3 = new float[]{45.0f, 27.0f, 37.947f, 5.292f, 56.413f, 18.708f, 33.587f, 18.708f, 52.053f, 5.292f, 45.0f, 27.0f};
        DashPattern l = new DashPattern();
        p.writePolygon(s0, (Object)l, new Color(200, 200, 200), true);
        p.writePolygon(s1, (Object)l, new Color(200, 200, 200), true);
        p.writePolygon(s2, (Object)l, new Color(100, 100, 100), true);
        p.writePolygon(s3, (Object)l, new Color(100, 100, 100), true);
        return p;
    }
}

