/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.io.File;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.AbstFileUtil;

public class PdfCommandImageJpeg {
    private String mFile;
    private int mWidth;
    private int mHeight;
    private byte[] mJpegData;

    protected void finalize() throws Throwable {
        this.mJpegData = null;
        super.finalize();
    }

    public void setFile(String file) {
        this.mFile = file;
    }

    public void createImageInfo() throws Exception {
        if (this.mFile == null) {
            return;
        }
        AbstFile af = new AbstFile();
        AbstFileUtil.read((AbstFile)af, (File)new File(this.mFile));
        this.createImageInfo(af.getData());
    }

    public void createImageInfo(byte[] jpgdata) throws Exception {
        this.mJpegData = jpgdata;
        try {
            int theLowByte;
            int theHighByte;
            int count = 3;
            do {
                int x0 = this.mJpegData[++count] & 0xFF;
                int x1 = this.mJpegData[++count] & 0xFF;
                long markLength = x0 << 8 | x1;
                count = (int)((long)count + (markLength -= 2L));
                theHighByte = this.mJpegData[++count] & 0xFF;
                theLowByte = this.mJpegData[++count] & 0xFF;
            } while (theHighByte != 255 || theLowByte != 192 && theLowByte != 193 && theLowByte != 194 && theLowByte != 195 && theLowByte != 197 && theLowByte != 198 && theLowByte != 199 && theLowByte != 201 && theLowByte != 202 && theLowByte != 203 && theLowByte != 205 && theLowByte != 206 && theLowByte != 207);
            count += 3;
            int h0 = this.mJpegData[++count] & 0xFF;
            int h1 = this.mJpegData[++count] & 0xFF;
            int w0 = this.mJpegData[++count] & 0xFF;
            int w1 = this.mJpegData[++count] & 0xFF;
            this.mHeight = h0 << 8 | h1;
            this.mWidth = w0 << 8 | w1;
        }
        catch (Exception e) {
            this.mWidth = -1;
            this.mHeight = -1;
            System.out.println(e.getMessage());
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public byte[] getData() {
        return this.mJpegData;
    }
}

