/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;

public class PdfCommandImage {
    private Component mComponent;
    private String mFile;
    private int mWidth;
    private int mHeight;

    public PdfCommandImage(String file) {
        this(file, new Panel());
    }

    public PdfCommandImage(String file, Component comp) {
        this.setFile(file);
        this.mComponent = comp;
    }

    public void setFile(String file) {
        this.mFile = file;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int[] getPixels() {
        Image img = this.getImage();
        if (img == null) {
            return null;
        }
        this.mWidth = img.getWidth(this.mComponent);
        this.mHeight = img.getHeight(this.mComponent);
        int[] pixels = new int[this.mWidth * this.mHeight];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.mWidth, this.mHeight, pixels, 0, this.mWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted [ " + this.mFile + " ]");
            return null;
        }
        return pixels;
    }

    private Image getImage() {
        if (this.mFile == null) {
            return null;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(this.mFile);
        MediaTracker mt = new MediaTracker(this.mComponent);
        mt.addImage(img, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        return img;
    }
}

