/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.awt.Color;
import java.awt.Image;
import java.awt.Polygon;
import java.io.OutputStream;
import jp.kitec.lib.util.RefList;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PageSize;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.util.PdfRect;

public class PdfDrawer {
    protected PdfDocument document;
    Contents mContents;
    PdfOutFile targetFile;
    protected PageSize mPageSize = new PageSize();

    public PdfDrawer() {
        this.document = new PdfDocument();
    }

    public void addPage() {
        Page page = this.getBody().createPage(this.mPageSize.getPageRect("A4"));
        this.getBody().addPage(page);
        this.mContents = this.getBody().getCurrentPage().getContents();
    }

    public void addPage(int width, int height) {
        Page p = this.document.getBody().createPage(new PdfRect(0.0f, 0.0f, width, height));
        this.document.getBody().addPage(p);
    }

    public void addPage(float width, float height) {
        Page p = this.document.getBody().createPage(new PdfRect(0.0f, 0.0f, (int)width, (int)height));
        this.document.getBody().addPage(p);
    }

    public void addPage(PdfRect box) {
        Page p = this.document.getBody().createPage(box);
        this.document.getBody().addPage(p);
        this.mContents = this.document.getBody().getCurrentPage().getContents();
    }

    public void setNowContents(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.document.getBody().getPagesCount()) {
            this.document.getBody().setCurrentPage(pageIndex);
            this.mContents = this.document.getBody().getCurrentPage().getContents();
        }
    }

    public Contents getNowContents() {
        this.mContents = this.document.getBody().getCurrentPage().getContents();
        return this.mContents;
    }

    public Page getCurrentPage() {
        return this.document.getBody().getCurrentPage();
    }

    public void setPageSize(PdfRect pageSize) {
        this.getCurrentPage().setMediabox(pageSize);
    }

    public void writeLine(float x1, float y1, float x2, float y2, Object ltype, Color c) {
        if (this.mContents != null) {
            this.mContents.writeLine(x1, y1, x2, y2, ltype, c);
        }
    }

    public void writeRectangle(float x, float y, float width, float height, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writeRectangle(x, y, width, height, ltype, c, isFill);
        }
    }

    public void writeArc(float x, float y, float r, float h, float start, float ang, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writeArc(x, y, r, h, start, ang, ltype, c, isFill);
        }
    }

    public void writeEllipse(float x, float y, float r, float h, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writeEllipse(x, y, r, h, ltype, c, isFill);
        }
    }

    public void writeCircle(float x, float y, float r, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writeCircle(x, y, r, ltype, c, isFill);
        }
    }

    public void writePolygon(Polygon p, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writePolygon(p, ltype, c, isFill);
        }
    }

    public void writePolygon(RefList shape, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writePolygon(shape, ltype, c, isFill);
        }
    }

    public void writePolygon(float[] array, Object ltype, Color c, boolean isFill) {
        if (this.mContents != null) {
            this.mContents.writePolygon(array, ltype, c, isFill);
        }
    }

    public void writeImage(ImageXObject img, float x, float y, float width, float height, float ang) {
        if (this.mContents != null) {
            this.mContents.writeImage(img, x, y, width, height, ang);
        }
    }

    public void writeForm(FormXObject form, float x, float y, float width, float height, float ang) {
        if (this.mContents != null) {
            this.mContents.writeForm(form, x, y, width, height, ang);
        }
    }

    public void writeForm(FormXObject form, float x, float y, float width, float height, float ang, float border, Object lStyle, Color borderColor) {
        if (this.mContents != null) {
            this.mContents.writeForm(form, x, y, width, height, ang, border, lStyle, borderColor);
        }
    }

    public void writeImage(Image img, float x, float y, float width, float height, float ang) {
        ImageXObject imgX = new ImageXObject(img);
        if (this.mContents != null) {
            this.mContents.writeImage(imgX, x, y, width, height, ang);
        }
    }

    public void writeImage(int[] p, int imgW, int imgH, float x, float y, float width, float height, float ang) {
        ImageXObject imgX = new ImageXObject(p, imgW, imgH);
        if (this.mContents != null) {
            this.mContents.writeImage(imgX, x, y, width, height, ang);
        }
    }

    public void writeLink(String url, PdfRect rect) {
        if (this.mContents != null) {
            this.mContents.writeLink(url, rect);
        }
    }

    public void writeLink(PdfRect rect, String url, float border) {
        if (this.mContents != null) {
            this.mContents.writeLink(url, rect, border);
        }
    }

    public void writeText(String str, float x, float y, String fontName, float fontSize, Color c, boolean center, int style, float skew, float rotate, float width, String type, boolean embed) {
        if (this.mContents != null) {
            this.mContents.writeText(str, x, y, fontName, fontSize, c, center, style, skew, rotate, width, type, embed);
        }
    }

    public void openFile(String fileName) {
        this.targetFile = new PdfOutFile();
        this.targetFile.setFile(fileName);
        this.document.setOutputFile(this.targetFile);
    }

    public void closeFile() {
        int size = this.document.getBody().getPagesCount();
        for (int i = 0; i < size; ++i) {
            this.document.getBody().getPageElementAt(i).getContents().endContents();
        }
    }

    public boolean writeToFile() {
        if (this.targetFile == null || this.targetFile.getPath().equals("")) {
            return false;
        }
        return this.document.writeToFile();
    }

    public void writeToStream(OutputStream out) {
        this.document.writeToStream(out);
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public Body getBody() {
        return this.document.getBody();
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }

    public void flush() {
        if (this.document != null) {
            this.document.flush();
        }
    }

    public PdfOutFile getTargetFile() {
        return this.targetFile;
    }

    public void flushStream() {
        this.document.flush();
    }

    public void setTargetFile(PdfOutFile af) {
        this.targetFile = af;
    }
}

