/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.awt.Color;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.Path;

public class PathText
implements Path {
    protected String mText;
    protected float mX;
    protected float mY;
    protected String mFontName;
    protected float mFontSize;
    protected Color mColor;
    protected boolean mCenter;
    protected int mStyle;
    protected float mSkew;
    protected float mRotate;
    protected float mWidth;
    protected String mType;
    protected boolean mEmbed;
    protected int mParamCount;

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color) {
        this(text, x, y, fontName, fontSize, color, false);
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center) {
        this.mText = text;
        this.mX = x;
        this.mY = y;
        this.mFontName = fontName;
        this.mFontSize = fontSize;
        this.mColor = color;
        this.mCenter = center;
        this.mParamCount = 7;
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center, int style) {
        this(text, x, y, fontName, fontSize, color, center);
        this.mStyle = style;
        this.mParamCount = 8;
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center, int style, float skew) {
        this(text, x, y, fontName, fontSize, color, center, style, skew, 0.0f);
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center, int style, float skew, float rotate) {
        this(text, x, y, fontName, fontSize, color, center, style);
        this.mSkew = skew;
        this.mRotate = rotate;
        this.mParamCount = 10;
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center, int style, float skew, float rotate, float width, String type) {
        this(text, x, y, fontName, fontSize, color, center, style, skew, rotate);
        this.mWidth = width;
        this.mType = type;
        this.mParamCount = 12;
    }

    public PathText(String text, float x, float y, String fontName, float fontSize, Color color, boolean center, int style, float skew, float rotate, float width, String type, boolean embed) {
        this(text, x, y, fontName, fontSize, color, center, style, skew, rotate, width, type);
        this.mEmbed = embed;
        this.mParamCount = 13;
    }

    @Override
    public boolean draw(Contents con) {
        switch (this.mParamCount) {
            case 7: {
                con.writeText(this.mText, this.mX, this.mY, this.mFontName, this.mFontSize, this.mColor, this.mCenter);
                return true;
            }
            case 8: {
                con.writeText(this.mText, this.mX, this.mY, this.mFontName, this.mFontSize, this.mColor, this.mCenter, this.mStyle);
                return true;
            }
            case 10: {
                con.writeText(this.mText, this.mX, this.mY, this.mFontName, this.mFontSize, this.mColor, this.mCenter, this.mStyle, this.mSkew, this.mRotate);
                return true;
            }
            case 12: {
                con.writeText(this.mText, this.mX, this.mY, this.mFontName, this.mFontSize, this.mColor, this.mCenter, this.mStyle, this.mSkew, this.mRotate, this.mWidth, this.mType);
                return true;
            }
            case 13: {
                con.writeText(this.mText, this.mX, this.mY, this.mFontName, this.mFontSize, this.mColor, this.mCenter, this.mStyle, this.mSkew, this.mRotate, this.mWidth, this.mType, this.mEmbed);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPattern(String name) {
    }

    @Override
    public void setShading(String name) {
    }
}

