/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfUtil;

public class PdfDocumentInfo
extends PdfIndirectObject
implements DefinedName {
    private String title = "";
    private String author = "";
    private String subject = "";
    private String keywords = "";
    private String creator = "";
    private String producer = "";
    private PdfDictionary dict = new PdfDictionary();
    private PdfDocument document;
    private Date date;
    private Date modDate;
    private PdfUtil mPdfUtil = new PdfUtil();

    public PdfDocumentInfo() {
        this.setCreationDate(new GregorianCalendar().getTime());
        this.setCreator("Kitec Corp");
        this.setProducer("Kitec Corp pdf Creator");
    }

    protected void finalize() throws Throwable {
        this.dict.clear();
        this.dict = null;
        super.finalize();
    }

    public PdfDocumentInfo(PdfDocument document) {
        this();
        this.document = document;
    }

    public PdfDictionary getDict() {
        return this.dict;
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void setDocument(PdfDocument document) {
        this.document = document;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.dict.put(TITLE, this.mPdfUtil.toTextString(title));
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
        this.dict.put(AUTHOR, this.mPdfUtil.toTextString(author));
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.dict.put(SUBJECT, this.mPdfUtil.toTextString(subject));
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
        this.dict.put(KEYWORDS, this.mPdfUtil.toTextString(keywords));
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        this.dict.put(CREATOR, this.mPdfUtil.toTextString(creator));
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
        this.dict.put(PRODUCER, this.mPdfUtil.toTextString(producer));
    }

    public Date getCreationDate() {
        return this.date;
    }

    public void setCreationDate(Date date) {
        this.date = date;
        this.dict.put(CREATIONDATE, this.mPdfUtil.toTextString(this.mPdfUtil.toDateString(date)));
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date date) {
        this.modDate = date;
        this.dict.put(MODDATE, this.mPdfUtil.toTextString(this.mPdfUtil.toDateString(date)));
    }

    public void setTrapped(PdfName trapped) {
        this.dict.put(TRAPPED, trapped);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.setModDate(new GregorianCalendar().getTime());
        pw.println(super.getObjectNumber() + " " + super.getGenerationNumber() + " obj");
        pw.println(this.dict);
        pw.println("endobj");
        return sw.toString();
    }

    @Override
    public void write(PdfOutFile out) {
        out.getPrintStream().println(this.toString());
    }
}

