/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.function;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DictObj;

public class Function
extends DictObj {
    private int mFuncType;
    private float[] mDomain;
    private float[] mRange;

    public Function(Body body, int type) {
        super(body);
        body.add(this);
        this.setFunctionType(type);
    }

    public void setFunctionType(int type) {
        this.mFuncType = type;
    }

    public void setDomain(float[] domain) {
        this.mDomain = domain;
    }

    public void setRange(float[] range) {
        this.mRange = range;
    }

    @Override
    public void updateDict() {
        this.dict.clear();
        this.dict.put(FUNCTIONTYPE, new Integer(this.mFuncType));
        String s = this.toArrayString(this.mDomain, true);
        if (s != null) {
            this.dict.put(DOMAIN, s);
        }
        if ((s = this.toArrayString(this.mRange, true)) != null) {
            this.dict.put(RANGE, s);
        }
    }

    protected String toArrayString(float[] array, boolean bracket) {
        if (array == null || array.length < 1) {
            return null;
        }
        if (array.length == 1 && !bracket) {
            return String.valueOf(array[0]);
        }
        StringBuffer sb = new StringBuffer("[");
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(" ");
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

