/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class NameTable
extends TTFTable {
    int format;
    int recordsCount;
    int stringOffset;
    int[] Platforms;
    int[] platformSpecificIDs;
    int[] languageIDs;
    int[] nameIDs;
    int[] lengths;
    int[] offsets;
    String[] names;
    public String copyRightNotice;
    public String familyName;
    public String subFamilyName;
    public String fullName;
    public String fontName;

    @Override
    public void loadFontData(TrueTypeFontFileReader fr) {
        try {
            fr.seekTable(this);
            this.format = fr.readUInt16();
            this.recordsCount = fr.readUInt16();
            this.stringOffset = fr.readUInt16();
            this.Platforms = new int[this.recordsCount];
            this.platformSpecificIDs = new int[this.recordsCount];
            this.languageIDs = new int[this.recordsCount];
            this.nameIDs = new int[this.recordsCount];
            this.lengths = new int[this.recordsCount];
            this.offsets = new int[this.recordsCount];
            this.names = new String[this.recordsCount];
            long recordStart = fr.getFilePointer();
            block9: for (int i = 0; i < this.recordsCount; ++i) {
                fr.seek(recordStart + (long)(i * 12));
                this.Platforms[i] = fr.readUInt16();
                this.platformSpecificIDs[i] = fr.readUInt16();
                this.languageIDs[i] = fr.readUInt16();
                this.nameIDs[i] = fr.readUInt16();
                this.lengths[i] = fr.readUInt16();
                this.offsets[i] = fr.readUInt16();
                fr.seek(this.offset + (long)this.stringOffset + (long)this.offsets[i]);
                if (this.Platforms[i] == 1) {
                    this.names[i] = fr.readByteString(this.lengths[i]);
                } else if (this.Platforms[i] == 3) {
                    this.names[i] = fr.readChars(this.lengths[i] / 2);
                }
                switch (this.nameIDs[i]) {
                    case 0: {
                        this.copyRightNotice = this.names[i];
                        continue block9;
                    }
                    case 1: {
                        this.familyName = this.names[i];
                        continue block9;
                    }
                    case 2: {
                        this.subFamilyName = this.names[i];
                        continue block9;
                    }
                    case 4: {
                        this.fullName = this.names[i];
                        continue block9;
                    }
                    case 6: {
                        this.fontName = this.names[i];
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        String re = null;
        re = "[  copyRightNotice: " + this.copyRightNotice + "\n" + "  familyName: " + this.familyName + "\n" + "  subFamilyName: " + this.subFamilyName + "\n" + "  fullName: " + this.fullName + "\n" + "  fontName: " + this.fontName + "  ]";
        return re;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFormat() {
        return this.format;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }
}

