/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class PdfUtil {
    private SimpleDateFormat format = new SimpleDateFormat("'D:'yyyyMMddHHmmss");
    private GregorianCalendar calendar = new GregorianCalendar();
    private DecimalFormat df = new DecimalFormat();
    private FieldPosition mFpos = new FieldPosition(0);
    private int mCurrentDigits;
    private int mUserDigits;

    protected void finalize() throws Throwable {
        this.format = null;
        this.calendar = null;
        this.df = null;
        this.mFpos = null;
        super.finalize();
    }

    public PdfUtil() {
        this(4);
    }

    public PdfUtil(int i) {
        this.mUserDigits = i;
    }

    public String toTextString(String string) {
        return "(" + string + ")";
    }

    public String toDateString(Date date) {
        FieldPosition fpos = new FieldPosition(0);
        int zoneOffset = this.calendar.get(15) / 3600000;
        this.df.format((long)Math.abs(zoneOffset), new StringBuffer(), fpos);
        return this.format.format(date);
    }

    public String formatPrint(float f) {
        return this.formatPrint(f, this.mUserDigits);
    }

    public String formatPrint(float f, int digits) {
        StringBuffer strBuff = new StringBuffer();
        this.df.setGroupingUsed(false);
        if (digits != this.mCurrentDigits) {
            this.df.setMinimumFractionDigits(digits);
            this.df.setMaximumFractionDigits(digits);
            this.mCurrentDigits = digits;
        }
        this.df.format((double)f, strBuff, this.mFpos);
        return strBuff.toString();
    }

    public int getUserDigits() {
        return this.mUserDigits;
    }

    public void setUserDigits(int userDigits) {
        this.mUserDigits = userDigits;
    }
}

