/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.util.Vector;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathPolygon;

public class PathGroupPolygon
implements Path {
    protected Vector mPolys = new Vector();
    protected String mPattern;
    protected boolean mIsShading;

    protected void finalize() throws Throwable {
        this.mPolys.removeAllElements();
        this.mPolys = null;
        super.finalize();
    }

    public void addPolygon(PathPolygon p) {
        this.mPolys.addElement(p);
    }

    @Override
    public boolean draw(Contents con) {
        int sz = this.mPolys.size();
        if (sz == 0) {
            return false;
        }
        float[][] points = new float[sz][];
        PathPolygon p = null;
        for (int i = 0; i < points.length; ++i) {
            p = (PathPolygon)this.mPolys.elementAt(i);
            points[i] = p.mPoints;
        }
        if (this.mPattern == null) {
            con.writeGroupPolygon(points, p.mLineStyle, p.mColor, p.mFill);
        } else if (this.mIsShading) {
            con.writeShadingGroupPolygon(points, this.mPattern);
        } else {
            con.writePatternedGroupPolygon(points, this.mPattern);
        }
        return true;
    }

    @Override
    public void setPattern(String name) {
        this.mPattern = name;
        this.mIsShading = false;
    }

    @Override
    public void setShading(String name) {
        this.mPattern = name;
        this.mIsShading = true;
    }
}

