/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;

public class FormXObject
extends Contents
implements PdfXObject,
DefinedName {
    private static final String DEFAULT_FORM_NAME = "XF1";
    private PdfName name;
    private float width;
    private float height;
    private float border = 0.0f;
    private Color borderColor = Color.black;
    private PdfMetrices mTransMatrices = new PdfMetrices(3);

    public FormXObject(Body body, PdfRect mediabox, String name) {
        super(body, mediabox);
        this.mBody = body;
        this.mediabox = mediabox;
        this.width = mediabox.getWidth();
        this.height = mediabox.getHeight();
        body.add(this.resources);
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, new PdfName("Form"));
        this.dict.put(FORMTYPE, new Integer(1));
        this.dict.put(BBOX, mediabox);
        this.dict.put(RESOURCES, this.resources.getReference());
        if (name == null) {
            this.setName("xf" + (this.resources.getXObjectDictionary().size() + 1) + "");
        } else if (this.resources.getXObjectDictionary().containsKey(name)) {
            this.setName(name);
        } else {
            this.setName(name);
        }
        this.pageCoor();
    }

    public FormXObject(Body body, PdfRect mediabox) {
        this(body, mediabox, DEFAULT_FORM_NAME);
    }

    public FormXObject(Body body, PdfRect mediabox, int border) {
        this(body, mediabox);
        this.border = border;
        this.writeBorder();
    }

    public FormXObject(Body body, PdfRect mediabox, String name, int border) {
        this(body, mediabox, name);
        this.border = border;
        this.writeBorder();
    }

    @Override
    public void setName(String name) {
        this.name = new PdfName(name);
    }

    @Override
    public void setName(PdfName name) {
        this.name = name;
    }

    @Override
    public PdfName getName() {
        return this.name;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getBorder() {
        return this.border;
    }

    public void setBorder(float width) {
        this.border = width;
    }

    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    public void setMTransMatrices(PdfMetrices matrices) {
        this.mTransMatrices = matrices;
    }

    public void writeBorder() {
        this.writeBorder(this.border, new LineStyle(this.border), this.borderColor);
    }

    public void writeBorder(float border, LineStyle style, Color color) {
        if (border > 0.0f && border < this.height && border < this.width) {
            this.border = border;
            this.borderColor = color;
            this.writeRectangle(this.mediabox.getLux(), 0.0f, this.mediabox.getWidth(), this.mediabox.getHeight(), style, color, false);
        }
    }

    @Override
    public void pageCoor() {
        this.setDefaultCoor();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getName().equals(((FormXObject)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

