/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Panel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.AbstFileUtil;
import option.io.pdfcommon.command.PdfFormatParser;
import option.io.pdfcommon.path.Format;
import option.io.pdfcommon.path.Path;

public class PdfFormatReader {
    private AbstFile mData;
    private boolean mCanRead;
    private Format mFormat;
    private String mBase;
    private String mEncoding;

    public PdfFormatReader(String fileName, String encoding) {
        this.mEncoding = encoding;
        this.mData = new AbstFile();
        this.mCanRead = AbstFileUtil.read((AbstFile)this.mData, (File)new File(fileName));
        if (this.canRead()) {
            this.mBase = this.mData.getParent();
            String name = this.mData.getName();
            int pos = name.lastIndexOf(".");
            this.mFormat = new Format(name.substring(0, pos), fileName);
        }
    }

    public boolean canRead() {
        return this.mCanRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format getFormat() {
        BufferedReader br;
        if (!this.canRead()) {
            return null;
        }
        PdfFormatParser parser = new PdfFormatParser(this.mBase, new Panel());
        try {
            br = this.mData.openBufferedReader(this.mEncoding);
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Path path = parser.parseDrawCommand(line);
                if (path == null) continue;
                this.mFormat.add(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Format format = null;
            return format;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return this.mFormat;
    }
}

