/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.PrintStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObjectJpeg
extends ImageXObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName name;
    private int width = 1;
    private int height = 1;
    private PdfMetrices mTransMatrices = new PdfMetrices(2);

    public ImageXObjectJpeg() {
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, IMAGE);
    }

    public ImageXObjectJpeg(byte[] jpgdata, int width, int height) {
        this();
        this.setImage(jpgdata, width, height);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.stream != null) {
                this.stream.flush();
                this.stream.close();
                this.stream = null;
            }
        }
        catch (Exception e) {
            try {
                this.stream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        super.finalize();
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.dict.put(WIDTH, new Integer(width));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.dict.put(HEIGHT, new Integer(height));
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setName(PdfName name) {
        this.name = name;
    }

    @Override
    public void setName(String name) {
        this.setName(new PdfName(name));
    }

    @Override
    public PdfName getName() {
        return this.name;
    }

    @Override
    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    @Override
    public void setMTransMatrices(PdfMetrices matrices) {
        this.mTransMatrices = matrices;
    }

    @Override
    public void setImage(Image image) throws IllegalStateException {
        MediaTracker mt = new MediaTracker(new Canvas());
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < 0 || height < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] pixels = new int[width * height];
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
        this.setImage(pixels, width, height);
    }

    protected void setImage(byte[] pixels, int width, int height) {
        this.setEntries();
        this.setWidth(width);
        this.setHeight(height);
        this.stream = new PdfStream();
        try {
            try {
                this.stream.write(pixels);
                this.stream.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    this.stream.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected void setEntries() {
        this.dict.put(FILTER, DCTDECODE);
        this.dict.put(COLORSPACE, DEVICERGB);
        this.dict.put(BITSPERCOMPONENT, 8);
        this.dict.put(INTERPOLATE, Boolean.TRUE);
    }

    @Override
    public void write(PdfOutFile output) {
        try {
            this.dict.put(LENGTH, new Integer(this.stream.size()));
            PrintStream ps = output.getPrintStream();
            this.startObject(output);
            ps.println(this.dict);
            ps.println("stream");
            this.stream.writeTo(output.getByteStream());
            ps.println("endstream");
            this.endObject(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

