/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class HtmxTable
extends TTFTable {
    public int numOfLongHorMetrics;
    public int[] advanceWidths;
    int[] leftSideBearings;

    @Override
    public void loadFontData(TrueTypeFontFileReader fr) {
        try {
            fr.seek(this.offset);
            this.advanceWidths = new int[this.numOfLongHorMetrics];
            this.leftSideBearings = new int[this.numOfLongHorMetrics];
            int i = 0;
            while (i < this.numOfLongHorMetrics) {
                this.advanceWidths[i] = fr.readUInt16();
                this.leftSideBearings[i] = fr.readInt16();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int[] getAdvanceWidths() {
        return this.advanceWidths;
    }

    public int[] getLeftSideBearings() {
        return this.leftSideBearings;
    }

    public int getNumOfLongHorMetrics() {
        return this.numOfLongHorMetrics;
    }

    public String toString() {
        return "[  Class: HtmxTable  numOfLongHorMetrics: " + this.numOfLongHorMetrics + "  ]";
    }
}

