/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.File;
import java.util.Vector;

public class FontFactory {
    private static String[][] FONTDATA;
    private static Vector mExtensions;
    private static String mFontDir;

    static {
        mExtensions = new Vector(2);
    }

    public static void setUseFonts(String[][] str) {
        FONTDATA = str;
    }

    public static void addExtension(String extension) {
        mExtensions.addElement(extension);
    }

    public static void removeExtension(String extension) {
        int count = FontFactory.getExtensionCount();
        int i = 0;
        while (i < count) {
            if (extension.equals(FontFactory.getExtension(i))) {
                mExtensions.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public static int getExtensionCount() {
        return mExtensions.size();
    }

    public static String getExtension(int index) {
        return (String)mExtensions.elementAt(index);
    }

    public static void setFontDirectory(String dir) {
        mFontDir = dir;
    }

    public static String getFontDirectory() {
        return mFontDir;
    }

    public static File getFontFile(String fontName) {
        int count = FontFactory.getExtensionCount();
        String fontfilename = "";
        if (FONTDATA != null) {
            String[][] stringArray = FONTDATA;
            int n = FONTDATA.length;
            int n2 = 0;
            while (n2 < n) {
                String[] data = stringArray[n2];
                if (data[0].equalsIgnoreCase(fontName)) {
                    fontfilename = data[1];
                    break;
                }
                ++n2;
            }
        }
        if (fontfilename == null || fontfilename.length() == 0) {
            fontfilename = "msgothic";
        }
        int i = 0;
        while (i < count) {
            File f = new File(String.valueOf(mFontDir) + "\\" + fontfilename + "." + FontFactory.getExtension(i));
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static boolean isProportionalFont(String fontName) {
        boolean isprop = false;
        if (FONTDATA != null) {
            String[][] stringArray = FONTDATA;
            int n = FONTDATA.length;
            int n2 = 0;
            while (n2 < n) {
                String[] data = stringArray[n2];
                if (data[0].equalsIgnoreCase(fontName)) {
                    if (data[2] == null || !data[2].equalsIgnoreCase("1")) break;
                    isprop = true;
                    break;
                }
                ++n2;
            }
        }
        return isprop;
    }
}

