/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Panel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.AbstFileUtil;
import option.io.pdfcommon.command.PdfFormatParser;
import option.io.pdfcommon.path.Format;
import option.io.pdfcommon.path.Path;

public class PdfFormatReader {
    private AbstFile mData = new AbstFile();
    private boolean mCanRead;
    private Format mFormat;
    private String mBase;

    public PdfFormatReader(String fileName) {
        this.mCanRead = AbstFileUtil.read((AbstFile)this.mData, (File)new File(fileName));
        if (this.canRead()) {
            this.mBase = this.mData.getParent();
            String name = this.mData.getName();
            int pos = name.lastIndexOf(".");
            this.mFormat = new Format(name.substring(0, pos), fileName);
        }
    }

    public boolean canRead() {
        return this.mCanRead;
    }

    public Format getFormat() {
        if (!this.canRead()) {
            return null;
        }
        PdfFormatParser parser = new PdfFormatParser(this.mBase, new Panel());
        BufferedReader br = this.mData.openBufferedReader();
        try {
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    Path path = parser.parseDrawCommand(line);
                    if (path == null) continue;
                    this.mFormat.add(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return this.mFormat;
    }
}

