/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import option.io.pdfcommon.font.TTFTable;

public class TrueTypeFontFileReader
extends RandomAccessFile {
    public TrueTypeFontFileReader(String name, String mode) throws FileNotFoundException {
        super(name, mode);
    }

    public int readUint8() throws IOException {
        int bb = this.read();
        if (bb < 0) {
            bb = 256 + bb;
        }
        return bb;
    }

    public int readInt8() throws IOException {
        return this.readByte();
    }

    public int readUInt16() throws IOException {
        return this.readUnsignedShort();
    }

    public int readInt16() throws IOException {
        return this.readShort();
    }

    public long readUInt32() throws IOException {
        long ret = this.readUint8();
        ret = (ret << 8) + (long)this.readUint8();
        ret = (ret << 8) + (long)this.readUint8();
        ret = (ret << 8) + (long)this.readUint8();
        return ret;
    }

    public int readInt32() throws IOException {
        return this.readInt();
    }

    public float readFixed() throws IOException {
        float fixed = 0.0f;
        int f1 = this.readInt16();
        int f2 = this.readUInt16();
        fixed = Float.parseFloat(String.valueOf(f1) + "." + String.valueOf(f2));
        return fixed;
    }

    public int readFWord() throws IOException {
        return this.readShort();
    }

    public int readUFWord() throws IOException {
        return this.readUnsignedShort();
    }

    public int readF2Dot14() throws IOException {
        return this.readShort();
    }

    public byte[] readLongDateTime() throws IOException {
        byte[] time = new byte[8];
        for (int i = 0; i < time.length; ++i) {
            time[i] = this.readByte();
        }
        return time;
    }

    public void seekTable(TTFTable table) throws IOException {
        this.seek(table.offset);
    }

    public String readChars(int n) {
        char[] cc = new char[n];
        for (int i = 0; i < n; ++i) {
            try {
                cc[i] = this.readChar();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return new String(cc);
    }

    public String readByteString(int n) {
        byte[] cc = new byte[n];
        for (int i = 0; i < n; ++i) {
            try {
                cc[i] = this.readByte();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return new String(cc);
    }
}

