/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class PdfFont
extends PdfIndirectObject
implements DefinedName {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    public static final int DEFAULT_CID_WIDTH = 600;
    protected PdfDictionary dict = new PdfDictionary();
    private FontDescriptor fontDescriptor = null;
    private Encoding encoding = new Encoding("MS932");
    private Vector descendantFontList = new Vector();
    private float size = 12.0f;
    CmapStream cmapStream = null;
    EmbedFontFile embedFontFile = null;
    private Font mFont;
    private FontMetrics mMetrics;

    public PdfFont() {
        this.dict.put(TYPE, FONT);
    }

    public void setSubtype(PdfName subtype) {
        this.dict.put(SUBTYPE, subtype);
    }

    public void setName(PdfName fontName) {
        this.dict.put(FONTNAME, fontName);
    }

    public void setBaseFont(PdfName baseFont) {
        this.dict.put(BASEFONT, baseFont);
    }

    public void setFontBBox(PdfRect fontBBox) {
        this.dict.put(FONTBBOX, fontBBox);
    }

    public void setFontMatrix(PdfArray fontMatrix) {
        this.dict.put(FONTMATRIX, fontMatrix);
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
        if (this.encoding == null) {
            this.encoding = new Encoding("MS932");
        }
        switch (encoding.getEncoingDataType()) {
            case 1: {
                this.dict.put(ENCODING, encoding.getEncodingPdfName());
                break;
            }
            case 2: {
                this.dict.put(ENCODING, encoding.getEncodingDict());
                this.dict.put(CHARPROCS, encoding.getCharProcs());
                this.setWidths(encoding.getWidths());
                break;
            }
            default: {
                this.dict.put(ENCODING, encoding.getEncodingPdfName());
            }
        }
    }

    public void setFirstChar(int firstChar) {
        this.dict.put(FIRSTCHAR, new Integer(firstChar));
    }

    public void setLastChar(int lastChar) {
        this.dict.put(LASTCHAR, new Integer(lastChar));
    }

    public void setWidths(PdfArray widths) {
        this.dict.put(WIDTHS, widths);
    }

    public void setFontDescriptor(FontDescriptor fontDescriptor) {
        this.fontDescriptor = fontDescriptor;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setDescendantFont(CIDFont font) {
        this.descendantFontList.addElement(font);
    }

    public PdfName getSubtype() {
        return (PdfName)this.dict.get(SUBTYPE);
    }

    public PdfName getName() {
        return (PdfName)this.dict.get(FONTNAME);
    }

    public PdfName getBaseFont() {
        return (PdfName)this.dict.get(BASEFONT);
    }

    public int getFirstChar() {
        return (Integer)this.dict.get(FIRSTCHAR);
    }

    public int getLastChar() {
        return (Integer)this.dict.get(LASTCHAR);
    }

    public PdfArray getWidths() {
        return (PdfArray)this.dict.get(WIDTHS);
    }

    public FontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    public PdfName getEncodingName() {
        return (PdfName)this.dict.get(ENCODING);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSize() {
        return this.size;
    }

    public Vector getDescendantFonts() {
        return this.descendantFontList;
    }

    public void setCmapStream(CmapStream cs) {
        this.cmapStream = cs;
    }

    public CmapStream getCmapStream() {
        return this.cmapStream;
    }

    public void setEmbedFontFile(EmbedFontFile eff) {
        this.embedFontFile = eff;
    }

    public EmbedFontFile getEmbedFontFile() {
        return this.embedFontFile;
    }

    public String toString() {
        if (this.fontDescriptor != null) {
            this.dict.put(FONTDESCRIPTOR, this.fontDescriptor.getReference());
        }
        if (this.containDescendantFont()) {
            this.dict.put(DESCENDANTFONTS, this.getDescendantFontReferences());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(super.getObjectNumber() + " " + super.getGenerationNumber() + " obj");
        pw.println(this.dict);
        pw.println("endobj");
        return sw.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PdfFont font = (PdfFont)obj;
        return this.getName().equals(font.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int stringWidth(String str) {
        char[] charArray = str.toCharArray();
        int result = 0;
        for (int i = 0; i < charArray.length; ++i) {
            result += this.charWidth(charArray[i]);
        }
        return result;
    }

    public int charWidth(char ch) {
        return this.getFontMetrics().charWidth(ch) > 800 ? 1000 : 600;
    }

    private FontMetrics getFontMetrics() {
        String name = this.getBaseFont().getName();
        if (this.mFont == null || !this.mFont.getName().equals(name)) {
            this.mFont = new Font(name, 0, 1000);
            this.mMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.mFont);
        }
        return this.mMetrics;
    }

    public int getAscent() {
        return 0;
    }

    public int getDescent() {
        return 0;
    }

    private boolean containDescendantFont() {
        return this.descendantFontList.size() > 0;
    }

    private PdfArray getDescendantFontReferences() {
        HashMap<String, String> map = new HashMap<String, String>();
        PdfArray fonts = new PdfArray();
        int sz = this.descendantFontList.size();
        for (int i = 0; i < sz; ++i) {
            String ref = ((CIDFont)this.descendantFontList.elementAt(i)).getReference();
            if (map.get(ref) != null) continue;
            map.put(ref, "");
            fonts.addElement(ref);
        }
        return fonts;
    }

    @Override
    public void write(PdfOutFile out) {
        if (this.fontDescriptor != null) {
            this.dict.put(FONTDESCRIPTOR, this.fontDescriptor.getReference());
            if (this.embedFontFile != null) {
                this.fontDescriptor.setFontfile2(this.embedFontFile.getReference());
            }
        }
        if (this.containDescendantFont()) {
            this.dict.put(DESCENDANTFONTS, this.getDescendantFontReferences());
        }
        if (this.cmapStream != null) {
            this.dict.put(TOUNICODE, this.cmapStream.getReference());
        }
        this.startObject(out);
        this.dict.write(out);
        this.endObject(out);
    }
}

