/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import java.util.Hashtable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class FontDirectory
extends TTFTable {
    int numTables;
    public Hashtable tableCollection;

    public FontDirectory() {
        this.offset = 0L;
        this.tableName = "fontdirectory";
    }

    @Override
    public void loadFontData(TrueTypeFontFileReader fr) {
        try {
            fr.seek(this.offset);
            fr.skipBytes(4);
            this.numTables = fr.readUInt16();
            this.tableCollection = new Hashtable();
            fr.skipBytes(6);
            for (int i = 0; i < this.numTables; ++i) {
                DefaultTable ttft = new DefaultTable();
                ttft.tableName = fr.readByteString(4);
                ttft.checkSum = fr.readUInt32();
                ttft.offset = fr.readUInt32();
                ttft.length = (int)fr.readUInt32();
                this.tableCollection.put(ttft.tableName, ttft);
            }
        }
        catch (IOException e) {
            System.out.println("IOException on reading FontDirectory data");
        }
    }

    public String toString() {
        String re = "[ Class: FontDirectory  numTables: " + this.numTables;
        if (this.tableCollection != null) {
            for (String tn : this.tableCollection.keySet()) {
                TTFTable ttft = (TTFTable)this.tableCollection.get(tn);
                re = re + "\n";
                re = re + "  tableName: " + ttft.tableName;
                re = re + "  checkSum: " + ttft.checkSum;
                re = re + "  offset: " + ttft.offset;
                re = re + "  length: " + ttft.length;
            }
        }
        re = re + "  ]";
        return re;
    }

    public Hashtable getTableCollection() {
        return this.tableCollection;
    }
}

