/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.RootPages;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.util.PdfRect;

public class Page
extends DictObj {
    protected RootPages parent = null;
    protected PdfRect mediabox;
    protected Contents contents;
    protected PdfArray annotArray;

    public Page(Body body, PdfRect mediabox) {
        super(body);
        this.mediabox = mediabox;
        this.annotArray = new PdfArray();
        this.dict.put(TYPE, PAGE);
    }

    public void setParent(RootPages parent) {
        this.parent = parent;
    }

    public void setMediabox(PdfRect mediabox) {
        this.mediabox = mediabox;
    }

    public PdfRect getMediabox() {
        return this.mediabox;
    }

    public Contents getContents() {
        if (this.contents == null) {
            this.contents = new Contents(this.body, this.mediabox);
            this.body.add(this.contents);
            this.body.add(this.contents.getResources());
        }
        return this.contents;
    }

    public PdfArray getAnnotArray() {
        return this.annotArray;
    }

    public void setAnnotArray(PdfArray array) {
        this.annotArray = array;
    }

    @Override
    public void updateDict() {
        if (this.parent != null) {
            this.dict.put(PARENT, this.parent.getReference());
        }
        this.dict.put(MEDIABOX, this.mediabox);
        if (this.contents != null) {
            this.dict.put(CONTENTS, this.contents.getReference());
            this.dict.put(RESOURCES, this.contents.getResources().getReference());
            if (this.annotArray.size() > 0) {
                this.dict.put(ANNOTS, this.annotArray);
            }
        }
    }
}

