/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;

public class StreamObj
extends PdfIndirectObject
implements DefinedName {
    protected PdfStream stream = new PdfStream();
    protected PdfStream streamOut = new PdfStream();
    protected PdfDictionary dict = new PdfDictionary();
    protected boolean flagStreamCompress = true;
    protected boolean isCompressed = false;

    protected void compress() {
        try {
            if (this.flagStreamCompress) {
                if (!this.isCompressed) {
                    this.dict.put(FILTER, FLATEDECODE);
                    DeflaterOutputStream ds = new DeflaterOutputStream(this.streamOut);
                    this.stream.writeTo(ds);
                    ds.finish();
                    ds.close();
                    this.isCompressed = true;
                }
            } else {
                this.streamOut = this.stream;
            }
        }
        catch (IOException e) {
            this.isCompressed = false;
            this.streamOut = this.stream;
            e.printStackTrace();
        }
    }

    public boolean isFlagStreamCompress() {
        return this.flagStreamCompress;
    }

    public void setFlagStreamCompress(boolean b) {
        this.flagStreamCompress = b;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void write(PdfOutFile output) {
        this.compress();
        this.dict.put(LENGTH, new Integer(this.streamOut.size()));
        this.startObject(output);
        this.dict.write(output);
        this.streamOut.write(output);
        this.endObject(output);
    }
}

