/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CmapTable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.FontDirectory;
import option.io.pdfcommon.font.HeadTable;
import option.io.pdfcommon.font.HheaTable;
import option.io.pdfcommon.font.HtmxTable;
import option.io.pdfcommon.font.LocaTable;
import option.io.pdfcommon.font.MaxpTable;
import option.io.pdfcommon.font.NameTable;
import option.io.pdfcommon.font.OS2Table;
import option.io.pdfcommon.font.PostTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class TrueTypeFile {
    static final String[] TABLE_NAMES_SIMPLE = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final int[] ENTRY_SELECTOR;
    private FontDirectory mFontDirectory;
    private HeadTable mHeadTable;
    private MaxpTable mMaxpTable;
    private HheaTable mHheaTable;
    private NameTable mNameTable;
    private LocaTable mLocaTable;
    private CmapTable mCmapTable;
    private OS2Table mOS2Table;
    private PostTable mPostTable;
    private HtmxTable mHtmxTable;
    private String copyRightNotice;
    private String familyName;
    private String subFamilyName;
    private String fullName;
    private String fontName;
    private int flags;
    private int capHeight;
    private int ascent;
    private int dscent;
    private int stemV;
    private float ItalicAngle;
    private int[] fontBox = new int[4];
    private byte[] panose = new byte[10];
    private Hashtable cmaps;
    private Hashtable glyphData;
    private int[] glyphWidths;
    private long[] offsets;
    private Vector usedChars;
    private int firstChar;
    private int lastChar;
    private Hashtable tableCollection;
    public TrueTypeFontFileReader fr;
    int[] newOffsets;
    byte[] newGTable;
    byte[] newLocaTable;
    int gTableRealSize;
    int lTableRealSize;
    int[] usedGIInt;
    int[] usedGWidths;
    Hashtable usedGI_GW;

    static {
        int[] nArray = new int[21];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        ENTRY_SELECTOR = nArray;
    }

    public TrueTypeFile() {
        this.mFontDirectory = new FontDirectory();
        this.usedChars = new Vector();
    }

    public void loadFontDirectory() {
        this.mFontDirectory.loadFontData(this.fr);
        this.tableCollection = this.mFontDirectory.tableCollection;
        DefaultTable dt = (DefaultTable)this.tableCollection.get("name");
        if (dt != null) {
            this.mNameTable = new NameTable();
            this.mNameTable.tableName = dt.tableName;
            this.mNameTable.checkSum = dt.checkSum;
            this.mNameTable.offset = dt.offset;
            this.mNameTable.length = dt.length;
            this.mNameTable.loadFontData(this.fr);
        }
        this.copyRightNotice = this.mNameTable.copyRightNotice;
        this.familyName = this.mNameTable.familyName;
        this.subFamilyName = this.mNameTable.subFamilyName;
        this.fullName = this.mNameTable.fullName;
        this.fontName = this.mNameTable.fontName;
    }

    public void checkTTC(String selectedFontName) {
        String tag = this.fr.readByteString(4);
        if (tag.equals("ttcf")) {
            try {
                this.fr.skipBytes(4);
                int numFonts = (int)this.fr.readUInt32();
                long[] dirOffsets = new long[numFonts];
                int i = 0;
                while (i < numFonts) {
                    dirOffsets[i] = this.fr.readUInt32();
                    ++i;
                }
                i = 0;
                while (i < numFonts) {
                    this.mFontDirectory.offset = dirOffsets[i];
                    this.mFontDirectory.loadFontData(this.fr);
                    this.tableCollection = this.mFontDirectory.tableCollection;
                    DefaultTable dt = (DefaultTable)this.tableCollection.get("name");
                    if (dt != null) {
                        this.mNameTable = new NameTable();
                        this.mNameTable.tableName = dt.tableName;
                        this.mNameTable.checkSum = dt.checkSum;
                        this.mNameTable.offset = dt.offset;
                        this.mNameTable.length = dt.length;
                        this.mNameTable.loadFontData(this.fr);
                    }
                    if (!selectedFontName.equals(this.mNameTable.familyName)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("IOException on checking ttc");
            }
        } else {
            try {
                this.fr.seek(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void LoadFontData() {
        this.loadFontDirectory();
        DefaultTable dt = (DefaultTable)this.tableCollection.get("head");
        if (dt != null) {
            this.mHeadTable = new HeadTable();
            this.mHeadTable.tableName = dt.tableName;
            this.mHeadTable.checkSum = dt.checkSum;
            this.mHeadTable.offset = dt.offset;
            this.mHeadTable.length = dt.length;
            this.mHeadTable.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("hhea")) != null) {
            this.mHheaTable = new HheaTable();
            this.mHheaTable.tableName = dt.tableName;
            this.mHheaTable.checkSum = dt.checkSum;
            this.mHheaTable.offset = dt.offset;
            this.mHheaTable.length = dt.length;
            this.mHheaTable.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("hmtx")) != null) {
            this.mHtmxTable = new HtmxTable();
            this.mHtmxTable.tableName = dt.tableName;
            this.mHtmxTable.checkSum = dt.checkSum;
            this.mHtmxTable.offset = dt.offset;
            this.mHtmxTable.length = dt.length;
            this.mHtmxTable.numOfLongHorMetrics = this.mHheaTable.numOfLongHorMetrics;
            this.mHtmxTable.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("maxp")) != null) {
            this.mMaxpTable = new MaxpTable();
            this.mMaxpTable.tableName = dt.tableName;
            this.mMaxpTable.checkSum = dt.checkSum;
            this.mMaxpTable.offset = dt.offset;
            this.mMaxpTable.length = dt.length;
            this.mMaxpTable.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("loca")) != null) {
            this.mLocaTable = new LocaTable();
            this.mLocaTable.tableName = dt.tableName;
            this.mLocaTable.checkSum = dt.checkSum;
            this.mLocaTable.offset = dt.offset;
            this.mLocaTable.length = dt.length;
            this.mLocaTable.indexToLocFormat = this.mHeadTable.indexToLocFormat;
            this.mLocaTable.numGlyphs = this.mMaxpTable.numGlyphs;
            this.mLocaTable.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("glyf")) != null && this.mLocaTable != null) {
            this.glyphData = new Hashtable();
            int i = 0;
            while (i < this.mLocaTable.numGlyphs) {
                int dataLen = (int)(this.mLocaTable.offsets[i + 1] - this.mLocaTable.offsets[i]);
                if (dataLen > 0) {
                    byte[] data = new byte[dataLen];
                    try {
                        this.fr.seek(dt.offset + this.mLocaTable.offsets[i]);
                        this.fr.read(data);
                        if (data != null) {
                            this.glyphData.put(new Integer(i), data);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if ((dt = (DefaultTable)this.tableCollection.get("cmap")) != null) {
            this.mCmapTable = new CmapTable();
            this.mCmapTable.tableName = dt.tableName;
            this.mCmapTable.checkSum = dt.checkSum;
            this.mCmapTable.offset = dt.offset;
            this.mCmapTable.length = dt.length;
            this.mCmapTable.loadFontData(this.fr);
            this.cmaps = this.mCmapTable.getCmaps();
        }
        if ((dt = (DefaultTable)this.tableCollection.get("OS/2")) != null) {
            this.mOS2Table = new OS2Table();
            this.mOS2Table.tableName = dt.tableName;
            this.mOS2Table.checkSum = dt.checkSum;
            this.mOS2Table.offset = dt.offset;
            this.mOS2Table.length = dt.length;
            this.mOS2Table.unitsPerEm = this.mHeadTable.unitsPerEm;
            this.mOS2Table.loadFontData(this.fr);
        }
        if ((dt = (DefaultTable)this.tableCollection.get("post")) != null) {
            this.mPostTable = new PostTable();
            this.mPostTable.tableName = dt.tableName;
            this.mPostTable.checkSum = dt.checkSum;
            this.mPostTable.offset = dt.offset;
            this.mPostTable.length = dt.length;
            this.mPostTable.loadFontData(this.fr);
        }
        this.setFlags();
        this.flags = this.mHeadTable.flags;
        if (this.flags <= 0) {
            this.flags = 32;
        }
        this.fontBox[0] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.xMin, this.mHeadTable.unitsPerEm);
        this.fontBox[1] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.yMin, this.mHeadTable.unitsPerEm);
        this.fontBox[2] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.xMax, this.mHeadTable.unitsPerEm);
        this.fontBox[3] = this.mHeadTable.changeTTF2PdfUnit(this.mHeadTable.yMax, this.mHeadTable.unitsPerEm);
        this.ascent = this.mHheaTable.changeTTF2PdfUnit(this.mHheaTable.ascent, this.mHeadTable.unitsPerEm);
        this.dscent = this.mHheaTable.changeTTF2PdfUnit(this.mHheaTable.descent, this.mHeadTable.unitsPerEm);
        this.ItalicAngle = this.mPostTable.ItalicAngle;
        this.panose = this.mOS2Table.panose;
        this.capHeight = this.mOS2Table.changeTTF2PdfUnit(this.mOS2Table.sCapHeight, this.mHeadTable.unitsPerEm);
        this.glyphWidths = this.mHtmxTable.advanceWidths;
        this.offsets = this.mLocaTable.offsets;
    }

    private void setFlags() {
        if (this.mHeadTable == null) {
            return;
        }
        this.mHeadTable.flags = 0;
        if (this.mPostTable != null && this.mPostTable.ItalicAngle != 0.0f) {
            this.mHeadTable.flags |= 0x40;
        }
        if (this.mOS2Table != null) {
            if (this.mOS2Table.panose[0] == 3) {
                this.mHeadTable.flags |= 8;
            }
            if (this.mOS2Table.panose[1] != 0) {
                this.mHeadTable.flags |= 2;
            }
            if (this.mOS2Table.panose[2] >= 8) {
                this.mHeadTable.flags |= 0x40000;
            }
            if (this.mOS2Table.panose[3] != 9) {
                this.mHeadTable.flags |= 1;
            }
        }
        this.mHeadTable.flags |= 4;
        this.mHeadTable.flags |= 0x20000;
    }

    public void resetUsedChars(String addStr) {
        int i = 0;
        while (i < addStr.length()) {
            char cc = addStr.charAt(i);
            int size = this.usedChars.size();
            if (size == 0) {
                this.usedChars.add(new Integer(cc));
                this.firstChar = cc;
                this.lastChar = cc;
            } else if (this.usedChars.indexOf(new Integer(cc)) < 0) {
                this.usedChars.add(new Integer(cc));
            }
            if (cc > this.lastChar) {
                this.lastChar = cc;
            }
            if (cc < this.firstChar) {
                this.firstChar = cc;
            }
            ++i;
        }
    }

    static String toHex(int n) {
        String s = Integer.toHexString(n);
        return String.valueOf("<0000".substring(0, 5 - s.length())) + s + ">";
    }

    static void writeByte(byte[] b, int offset, byte data) {
        b[offset++] = data;
    }

    static void writeShort(byte[] b, int offset, int data) {
        b[offset++] = (byte)(data >> 8 & 0xFF);
        b[offset++] = (byte)(data & 0xFF);
    }

    static void writeInt(byte[] b, int offset, long data) {
        b[offset++] = (byte)(data >> 24 & 0xFFL);
        b[offset++] = (byte)(data >> 16 & 0xFFL);
        b[offset++] = (byte)(data >> 8 & 0xFFL);
        b[offset++] = (byte)(data & 0xFFL);
    }

    static void writeString(byte[] b, int offset, String s) {
        try {
            byte[] str = s.getBytes("ISO-8859-1");
            System.arraycopy(str, 0, b, offset, str.length);
            offset += b.length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public byte[] getFontData() {
        this.getNewGlyph();
        int fullSize = 0;
        int i = 0;
        while (i < TABLE_NAMES_SIMPLE.length) {
            if (TABLE_NAMES_SIMPLE[i] != "glyf" && TABLE_NAMES_SIMPLE[i] != "loca") {
                DefaultTable dt = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[i]);
                fullSize += dt.length + 3 & 0xFFFFFFFC;
            }
            ++i;
        }
        fullSize += this.newLocaTable.length;
        fullSize += this.newGTable.length;
        byte[] outFont = new byte[fullSize += 12 + 16 * TABLE_NAMES_SIMPLE.length];
        int nowPos = 0;
        TrueTypeFile.writeInt(outFont, nowPos, 65536L);
        TrueTypeFile.writeShort(outFont, nowPos += 4, TABLE_NAMES_SIMPLE.length);
        int selector = ENTRY_SELECTOR[TABLE_NAMES_SIMPLE.length];
        TrueTypeFile.writeShort(outFont, nowPos += 2, (1 << selector) * 16);
        TrueTypeFile.writeShort(outFont, nowPos += 2, selector);
        TrueTypeFile.writeShort(outFont, nowPos += 2, (TABLE_NAMES_SIMPLE.length - (1 << selector)) * 16);
        nowPos += 2;
        int startTable = 12 + 16 * TABLE_NAMES_SIMPLE.length;
        int i2 = 0;
        while (i2 < TABLE_NAMES_SIMPLE.length) {
            String name = TABLE_NAMES_SIMPLE[i2];
            TrueTypeFile.writeString(outFont, nowPos, name);
            nowPos += 4;
            DefaultTable dt = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[i2]);
            if (TABLE_NAMES_SIMPLE[i2] == "glyf") {
                TrueTypeFile.writeInt(outFont, nowPos, this.calculateChecksum(this.newGTable));
                dt.length = this.gTableRealSize;
            } else if (TABLE_NAMES_SIMPLE[i2] == "loca") {
                TrueTypeFile.writeInt(outFont, nowPos, this.calculateChecksum(this.newLocaTable));
                dt.length = this.lTableRealSize;
            } else {
                TrueTypeFile.writeInt(outFont, nowPos, dt.checkSum);
            }
            TrueTypeFile.writeInt(outFont, nowPos += 4, startTable);
            int len = dt.length + 3 & 0xFFFFFFFC;
            TrueTypeFile.writeInt(outFont, nowPos += 4, dt.length);
            nowPos += 4;
            startTable += len;
            ++i2;
        }
        i2 = 0;
        while (i2 < TABLE_NAMES_SIMPLE.length) {
            DefaultTable dt = (DefaultTable)this.tableCollection.get(TABLE_NAMES_SIMPLE[i2]);
            if (TABLE_NAMES_SIMPLE[i2] == "glyf") {
                System.arraycopy(this.newGTable, 0, outFont, nowPos, this.newGTable.length);
                nowPos += this.newGTable.length;
            } else if (TABLE_NAMES_SIMPLE[i2] == "loca") {
                System.arraycopy(this.newLocaTable, 0, outFont, nowPos, this.newLocaTable.length);
                nowPos += this.newLocaTable.length;
            } else {
                try {
                    this.fr.seek(dt.offset);
                    this.fr.readFully(outFont, nowPos, dt.length);
                    nowPos += dt.length + 3 & 0xFFFFFFFC;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        return outFont;
    }

    public void getUsedGlyphIndexs() {
        if (this.usedChars != null) {
            Vector<Object> usedGI = new Vector<Object>();
            int i = 0;
            while (i < this.usedChars.size()) {
                Integer c = (Integer)this.usedChars.elementAt(i);
                usedGI.add(this.cmaps.get(c));
                ++i;
            }
            if (usedGI.size() > 0 && !usedGI.contains(new Integer(0))) {
                usedGI.add(new Integer(0));
            }
            this.usedGIInt = new int[usedGI.size()];
            i = 0;
            while (i < usedGI.size()) {
                this.usedGIInt[i] = (Integer)usedGI.elementAt(i);
                ++i;
            }
            Arrays.sort(this.usedGIInt);
            this.usedGWidths = new int[this.usedGIInt.length];
            this.usedGI_GW = new Hashtable();
            int j = 0;
            while (j < this.usedGIInt.length) {
                this.usedGWidths[j] = this.mHtmxTable.changeTTF2PdfUnit(this.mHtmxTable.advanceWidths[this.usedGIInt[j]], this.mHeadTable.unitsPerEm);
                this.usedGI_GW.put(new Integer(this.usedGIInt[j]), new Integer(this.usedGWidths[j]));
                ++j;
            }
        }
    }

    private void getNewGlyph() {
        int[] usedGIs = this.usedGIInt;
        this.newGTable = null;
        this.newOffsets = new int[this.mLocaTable.numGlyphs + 1];
        int gtSize = 0;
        if (this.fr != null && this.tableCollection != null && this.usedChars != null) {
            int i = 0;
            while (i < usedGIs.length) {
                int usedGIndex = usedGIs[i];
                int len = (int)(this.offsets[usedGIndex + 1] - this.offsets[usedGIndex]);
                gtSize += len;
                ++i;
            }
            this.gTableRealSize = gtSize;
            this.newGTable = new byte[gtSize + 3 & 0xFFFFFFFC];
            int glyfPtr = 0;
            int listGlyf = 0;
            DefaultTable dt = (DefaultTable)this.tableCollection.get("glyf");
            int k = 0;
            while (k < this.newOffsets.length) {
                this.newOffsets[k] = glyfPtr;
                if (listGlyf < usedGIs.length && usedGIs[listGlyf] == k) {
                    ++listGlyf;
                    this.newOffsets[k] = glyfPtr;
                    long start = this.offsets[k];
                    int len = (int)(this.offsets[k + 1] - start);
                    if (len > 0) {
                        try {
                            this.fr.seek(dt.offset + start);
                            this.fr.readFully(this.newGTable, glyfPtr, len);
                            glyfPtr += len;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++k;
            }
            int locaTableRealSize = this.mLocaTable.indexToLocFormat == 0 ? this.newOffsets.length * 2 : this.newOffsets.length * 4;
            this.newLocaTable = new byte[locaTableRealSize + 3 & 0xFFFFFFFC];
            this.lTableRealSize = locaTableRealSize;
            int nowCur = 0;
            int i2 = 0;
            while (i2 < this.newOffsets.length) {
                if (this.mLocaTable.indexToLocFormat == 0) {
                    TrueTypeFile.writeShort(this.newLocaTable, nowCur, this.newOffsets[i2] / 2);
                    nowCur += 2;
                } else {
                    TrueTypeFile.writeInt(this.newLocaTable, nowCur, this.newOffsets[i2]);
                    nowCur += 4;
                }
                ++i2;
            }
        }
    }

    public String getUsedCmaps() {
        if (this.usedChars.size() == 0) {
            return null;
        }
        int fc = (Integer)this.cmaps.get(new Integer(this.firstChar));
        int lc = (Integer)this.cmaps.get(new Integer(this.lastChar));
        StringBuffer buf = new StringBuffer("/CIDInit /ProcSet findresource begin\n");
        buf.append("12 dict begin\n");
        buf.append("begincmap\n");
        buf.append("/CIDSystemInfo\n");
        buf.append("<< /Registry (Adobe)\n");
        buf.append("/Ordering (UCS)\n");
        buf.append("/Supplement 0\n");
        buf.append(">> def\n");
        buf.append("/CMapName /Adobe-Identity-UCS def\n");
        buf.append("/CMapType 2 def\n");
        buf.append("1 begincodespacerange\n");
        buf.append(TrueTypeFile.toHex(fc));
        buf.append(TrueTypeFile.toHex(lc));
        buf.append("\nendcodespacerange\n");
        buf.append(this.usedChars.size());
        buf.append(" beginbfrange\n");
        int i = 0;
        while (i < this.usedChars.size()) {
            Integer ch = (Integer)this.usedChars.elementAt(i);
            int code = ch;
            int glyfIndex = (Integer)this.cmaps.get(ch);
            buf.append(TrueTypeFile.toHex(code));
            buf.append(" ");
            buf.append(TrueTypeFile.toHex(code));
            buf.append(" ");
            buf.append(glyfIndex);
            buf.append("\n");
            ++i;
        }
        buf.append("endbfrange\n");
        buf.append("endcmap\n");
        buf.append("CMapName currentdict /CMap defineresource pop\n");
        buf.append("end end\n");
        return buf.toString();
    }

    public CmapTable getMCmapTable() {
        return this.mCmapTable;
    }

    public FontDirectory getMFontDirectory() {
        return this.mFontDirectory;
    }

    public HeadTable getMHeadTable() {
        return this.mHeadTable;
    }

    public HheaTable getMHheaTable() {
        return this.mHheaTable;
    }

    public LocaTable getMLocaTable() {
        return this.mLocaTable;
    }

    public MaxpTable getMMaxpTable() {
        return this.mMaxpTable;
    }

    public NameTable getMNameTable() {
        return this.mNameTable;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public Hashtable getCmaps() {
        return this.cmaps;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public int getDscent() {
        return this.dscent;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBox() {
        return this.fontBox;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Hashtable getGlyphData() {
        return this.glyphData;
    }

    public int[] getGlyphWidths() {
        return this.glyphWidths;
    }

    public float getItalicAngle() {
        return this.ItalicAngle;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public HtmxTable getMHtmxTable() {
        return this.mHtmxTable;
    }

    public OS2Table getMOS2Table() {
        return this.mOS2Table;
    }

    public PostTable getMPostTable() {
        return this.mPostTable;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getStemV() {
        return this.stemV;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public Vector getUsedChars() {
        return this.usedChars;
    }

    public void setMCmapTable(CmapTable table) {
        this.mCmapTable = table;
    }

    public void setMFontDirectory(FontDirectory directory) {
        this.mFontDirectory = directory;
    }

    public void setMHeadTable(HeadTable table) {
        this.mHeadTable = table;
    }

    public void setMHheaTable(HheaTable table) {
        this.mHheaTable = table;
    }

    public void setMLocaTable(LocaTable table) {
        this.mLocaTable = table;
    }

    public void setMMaxpTable(MaxpTable table) {
        this.mMaxpTable = table;
    }

    public void setMNameTable(NameTable table) {
        this.mNameTable = table;
    }

    protected int calculateChecksum(byte[] b) {
        int len = b.length / 4;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int ptr = 0;
        int k = 0;
        while (k < len) {
            v3 += b[ptr++] & 0xFF;
            v2 += b[ptr++] & 0xFF;
            v1 += b[ptr++] & 0xFF;
            v0 += b[ptr++] & 0xFF;
            ++k;
        }
        return v0 + (v1 << 8) + (v2 << 16) + (v3 << 24);
    }

    public static void main(String[] args) {
        try {
            TrueTypeFontFileReader fr = new TrueTypeFontFileReader("d:\\HGRPP1.TTC", "r");
            TrueTypeFile ttf = new TrueTypeFile();
            ttf.fr = fr;
            ttf.LoadFontData();
            ttf.resetUsedChars("\u65e5");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Hashtable getUsedGI_GW() {
        return this.usedGI_GW;
    }

    public int[] getUsedGIInt() {
        return this.usedGIInt;
    }

    public int[] getUsedGWidths() {
        return this.usedGWidths;
    }
}

