/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import d.d;
import java.io.IOException;
import java.util.Hashtable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class CmapTable
extends TTFTable {
    int version;
    int numberSubtables;
    int[] platformIDs;
    int[] platformSpecificIDs;
    long[] offsets;
    int[] formats;
    int[] lengths;
    int[] languages;
    int[] endCode;
    int[] startCode;
    int[] idDelta;
    int[] idRangeOffset;
    int[] glyphIndexArray;
    private Hashtable cmaps = new Hashtable();

    @Override
    public void loadFontData(TrueTypeFontFileReader fr) {
        try {
            fr.seek(this.offset);
            this.version = fr.readUInt16();
            this.numberSubtables = fr.readUInt16();
            this.platformIDs = new int[this.numberSubtables];
            this.platformSpecificIDs = new int[this.numberSubtables];
            this.offsets = new long[this.numberSubtables];
            this.formats = new int[this.numberSubtables];
            this.lengths = new int[this.numberSubtables];
            this.languages = new int[this.numberSubtables];
            int i = 0;
            while (i < this.numberSubtables) {
                fr.seek(this.offset + 4L + (long)(i * 8));
                this.platformIDs[i] = fr.readUInt16();
                this.platformSpecificIDs[i] = fr.readUInt16();
                this.offsets[i] = fr.readUInt32();
                ++i;
            }
            i = 0;
            while (i < this.numberSubtables) {
                fr.seek(this.offset + this.offsets[i]);
                this.formats[i] = fr.readUInt16();
                this.lengths[i] = fr.readUInt16();
                this.languages[i] = fr.readUInt16();
                if (this.formats[i] == 0) {
                    if (d.d) {
                        System.out.println("\u51e6\u7406\u672a\u5b9a");
                    }
                } else if (this.formats[i] == 4) {
                    int segCountX2 = fr.readUInt16();
                    fr.readUInt16();
                    fr.readUInt16();
                    fr.readUInt16();
                    int segCount = segCountX2 / 2;
                    this.endCode = new int[segCount];
                    this.startCode = new int[segCount];
                    this.idDelta = new int[segCount];
                    this.idRangeOffset = new int[segCount];
                    this.glyphIndexArray = new int[(this.length - 16 - segCount * 4 * 2) / 2];
                    int j = 0;
                    while (j < segCount) {
                        this.endCode[j] = fr.readUInt16();
                        ++j;
                    }
                    fr.skipBytes(2);
                    j = 0;
                    while (j < segCount) {
                        this.startCode[j] = fr.readUInt16();
                        ++j;
                    }
                    j = 0;
                    while (j < segCount) {
                        this.idDelta[j] = fr.readUInt16();
                        ++j;
                    }
                    j = 0;
                    while (j < segCount) {
                        this.idRangeOffset[j] = fr.readUInt16();
                        ++j;
                    }
                    j = 0;
                    while (j < this.glyphIndexArray.length) {
                        this.glyphIndexArray[j] = fr.readUInt16();
                        ++j;
                    }
                    int m = 0;
                    while (m < segCount) {
                        int nowCode = this.startCode[m];
                        while (nowCode <= this.endCode[m] && this.endCode[m] != 65535) {
                            int graphIndex;
                            if (this.idRangeOffset[m] == 0) {
                                graphIndex = nowCode + this.idDelta[m] & 0xFFFF;
                            } else {
                                int tt = nowCode - this.startCode[m] + this.idRangeOffset[m] / 2 + m - segCount;
                                graphIndex = this.glyphIndexArray[tt] + this.idDelta[m] & 0xFFFF;
                            }
                            this.cmaps.put(new Integer(nowCode), new Integer(graphIndex));
                            ++nowCode;
                        }
                        ++m;
                    }
                } else {
                    System.out.println("cmap unsupported format [" + this.formats[i] + "]");
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("IOException on reading cmap data");
        }
    }

    public Hashtable getCmaps() {
        return this.cmaps;
    }

    public String toString() {
        return "[ Class: CmapTable  cmap.size: " + this.cmaps.size() + "  ]";
    }
}

