/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.util.Vector;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;

public class Resources
extends DictObj {
    private Vector fontList = new Vector();
    private Vector patternList = new Vector();
    private Vector xObjectList = new Vector();
    private PdfDictionary fontDictionary = new PdfDictionary();
    private PdfDictionary patternDictionary = new PdfDictionary();
    private Vector mShadingList;
    private PdfDictionary mShadingDictionary;
    private PdfDictionary xObjectDictionary = new PdfDictionary();
    private PdfArray procSet;

    public Resources(Body body) {
        super(body);
        this.mShadingList = new Vector();
        this.mShadingDictionary = new PdfDictionary();
        this.procSet = new PdfArray();
        this.procSet.addElement(new PdfName("PDF"));
    }

    public boolean addFont(PdfFont font) {
        boolean add = false;
        if (this.fontList.indexOf(font) == -1) {
            this.fontList.addElement(font);
            add = true;
        }
        return add;
    }

    public void addPattern(Pattern pattern) {
        if (this.patternList.indexOf(pattern) == -1) {
            this.patternList.add(pattern);
        }
    }

    public void addShading(Shading shading) {
        if (this.mShadingList.indexOf(shading) == -1) {
            this.mShadingList.add(shading);
        }
    }

    public void addXObject(PdfXObject px) {
        if (!this.xObjectList.contains(px)) {
            if (px.getName() == null || this.xObjectDictionary.containsKey(px.getName())) {
                px.setName("xo" + this.xObjectList.size());
            }
            this.xObjectList.add(px);
            this.xObjectDictionary.put(px.getName(), px.getReference());
        }
    }

    public void useText() {
        if (this.procSet.indexOf(TEXT) == -1) {
            this.procSet.addElement(TEXT);
        }
    }

    public void useImageB() {
        if (this.procSet.indexOf(IMAGE_B) == -1) {
            this.procSet.addElement(IMAGE_B);
        }
    }

    public void useImageC() {
        if (this.procSet.indexOf(IMAGE_C) == -1) {
            this.procSet.addElement(IMAGE_C);
        }
    }

    public void useImageI() {
        if (this.procSet.indexOf(IMAGE_I) == -1) {
            this.procSet.addElement(IMAGE_I);
        }
    }

    @Override
    public void updateDict() {
        this.dict.remove(PROCSET);
        this.dict.put(PROCSET, this.procSet);
        int i = 0;
        while (i < this.fontList.size()) {
            PdfFont font = (PdfFont)this.fontList.elementAt(i);
            this.fontDictionary.put(font.getName(), font.getReference());
            ++i;
        }
        if (this.fontDictionary.size() > 0) {
            this.dict.remove(FONT);
            this.dict.put(FONT, this.fontDictionary);
        }
        i = 0;
        while (i < this.patternList.size()) {
            Pattern pattern = (Pattern)this.patternList.elementAt(i);
            this.patternDictionary.put(pattern.getName(), pattern.getReference());
            ++i;
        }
        if (this.patternDictionary.size() > 0) {
            this.dict.remove(PATTERN);
            this.dict.put(PATTERN, this.patternDictionary);
        }
        int i2 = 0;
        while (i2 < this.mShadingList.size()) {
            Shading shading = (Shading)this.mShadingList.elementAt(i2);
            this.mShadingDictionary.put(shading.getName(), shading.getReference());
            ++i2;
        }
        if (this.mShadingDictionary.size() > 0) {
            this.dict.remove(SHADING);
            this.dict.put(SHADING, this.mShadingDictionary);
        }
        if (this.xObjectDictionary.size() > 0) {
            this.dict.remove(XOBJECT);
            this.dict.put(XOBJECT, this.xObjectDictionary);
        }
    }

    public Vector getFontList() {
        return this.fontList;
    }

    public PdfDictionary getXObjectDictionary() {
        return this.xObjectDictionary;
    }

    public Vector getXObjectList() {
        return this.xObjectList;
    }
}

